
@if(isset($editInstructor))
    @foreach ($editInstructor->teachingCategories as $key => $teachingCategory)
    <div class="row mt-25">
        <div class="col-xl-4">
            <label class="primary_input_label"
                for="category">{{ __('courses.Category') }}</label>
            <select class="primary_select category_id" name="teachingCategory[{{ $key+100 }}][category]" id="category_id"
                {{ $errors->has('category') ? 'autofocus' : '' }}>
                <option data-display="{{ __('common.Select') }} {{ __('quiz.Category') }}"
                    value="">{{ __('common.Select') }} {{ __('quiz.Category') }} </option>
                @foreach ($categories as $category)
                    <option value="{{ $category->id }}" {{ $teachingCategory->category_id == $category->id ? 'selected':'' }}>{{ @$category->name }} </option>
                @endforeach
            </select>
        </div>

        <div class="col-xl-4 courseBox mt-30" id="subCategoryDiv">
            <select class="primary_select" name="teachingCategory[{{ $key+100 }}][sub_category]" id="subcategory_id"
                {{ $errors->has('sub_category') ? 'autofocus' : '' }}>
                <option
                    data-display="{{ __('common.Select') }} {{ __('courses.Sub Category') }}  "
                    value="">{{ __('common.Select') }} {{ __('courses.Sub Category') }}
                </option>
            </select>
        </div>

        <div class="col-xl-3">
            <label class="primary_input_label"
                for="category">{{ __('courses.Level') }}</label>
            <select class="primary_select" name="teachingCategory[{{ $key+100 }}][level]" id="category">
                <option data-display="{{ __('appointment.Select Level') }}" value="">
                    {{ __('appointment.Select Level') }}</option>
                @foreach ($levels as $level)
                    <option value="{{ $level->id }}" {{ $teachingCategory->level_id == $level->id ? 'selected':'' }}>{{ @$level->title }} </option>
                @endforeach
            </select>
        </div>
        <div class="col-xl-1 mt-33">
            <button class="removeTeachingCategoryBtn primary-btn icon-only fix-gr-bg fl-r"
                type="button">
                <span class="ti-trash"></span> </button>
        </div>
    </div>
    @endforeach
    @if (count($editInstructor->teachingCategories)==0)
        @includeIf('appointment::instructor.inc.create_teachingCategory')
    @endif
@endif
