<?php

namespace Modules\Appointment\Repositories\Eloquents;

use App\Repositories\Eloquents\BaseRepository;
use Modules\Appointment\Entities\HeroSection;
use Modules\Appointment\Repositories\Interfaces\FrontendRepositoryInterface;

class FrontendRepository extends BaseRepository implements FrontendRepositoryInterface
{
    protected $heroArea;
    public function __construct(
        HeroSection $heroArea
    ) {
        $this->heroArea = $heroArea;
    }
    public function index() :array
    {
        $data = [];
        return $data;
    }
    public function getHero() :array
    {
        $data['hero'] = $this->heroArea->where('lms_id', auth()->user()->lms_id)->first();
        return $data;
    }

    public function updateHero(array $playLoad)
    {
        $destination = 'Modules/Appointment/Resources/assets/frontend/img/tutor/';
        $hero = $this->heroArea->firstOrCreate([
            'lms_id' => auth()->user()->lms_id
        ]);
        $hero->title = gv($playLoad, 'title');
        $hero->short_description = gv($playLoad, 'short_description');
        $hero->background_image = fileUpdate($hero->background_image, gv($playLoad, 'background_image'), $destination);
        $hero->tutor_image = fileUpdate($hero->tutor_image, gv($playLoad, 'tutor_image'), $destination);
        $hero->save();
    }
}
