<?php

namespace Modules\Appointment\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Support\Facades\Session;
use Illuminate\Contracts\Support\Renderable;
use Modules\CourseSetting\Entities\Category;
use Modules\Appointment\Http\Requests\PostRequestForm;
use Modules\Appointment\Http\Requests\ShareInstructor;
use Modules\Appointment\Repositories\Interfaces\PostRequestRepositoryInterface;

class TutorPostController extends Controller
{
    public $postRequestRepository;

    public function __construct(
        PostRequestRepositoryInterface $postRequestRepository
    )
    {
        $this->postRequestRepository = $postRequestRepository;
    }

    public function index()
    {
        $categories = Category::get();
        $request = Session::get('request');
        return view(theme('pages.appointment_tutor_post_page'), compact('categories', 'request'));
    }

    public function list()
    {
        $data = $this->postRequestRepository->index();
        return view('appointment::post.request_list', $data);
    }


    public function store(PostRequestForm $request)
    {
        if (!auth()->check()) {
            $request->session()->forget('request');
            Session::push('request', $request->all());
            session(['redirectTo' => route('appointment.post.index')]);
            return \redirect(route('login'));
        }

        $this->postRequestRepository->create($request->except('_token'));
        Toastr::success(trans('appointment.Operation Successful !! Please Check Wishlist'), trans('common.Success'));
        return redirect()->route('appointment.instructors');
    }

    public function shareInstructor($id)
    {
        $data = $this->postRequestRepository->shareInstructor($id);
        return view('appointment::post.share_instructor', $data);
    }

    public function shareInstructorStore(ShareInstructor $request)
    {
        $data = $this->postRequestRepository->shareInstructorStore($request->all());
        Toastr::success(trans('common.Operation successful'), trans('common.Success'));
        return redirect()->route('appointment.post.list');
    }

    public function categoryInstructor(Request $request)
    {
        $instructors = $this->postRequestRepository->categoryInstructor($request->all());
        return response()->json(['instructors' => $instructors]);
    }


    public function destroy($id)
    {
        $this->postRequestRepository->deleteById($id);
        Toastr::success(trans('common.Operation successful'), trans('common.Success'));
        return redirect()->back();
    }
}
