<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRequestPostsTable extends Migration
{
    public function up()
    {
        Schema::create('request_posts', function (Blueprint $table) {
            $table->id();
            $table->integer('teaching_category')->nullable();
            $table->text('headline')->nullable();
            $table->text('requirement')->nullable();
            $table->integer('user_id')->nullable();
            $table->integer('min_price')->nullable();
            $table->integer('max_price')->nullable();
            $table->string('name')->nullable();
            $table->string('email')->nullable();
            $table->tinyInteger('status')->nullable()->default(1);
            $table->integer('lms_id')->default(1);

            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('request_posts');
    }
}
