@extends('backend.master')
@php
    $table_name='survey_question_set_attributes';
@endphp
@section('table')
    {{$table_name}}
@stop
@section('mainContent')
    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center mt-50">
                <div class="col-lg-3">
                    <div class="main-title">
                        <h3 class="mb-20"> @if (isset($edit))
                                {{ __('common.Update') }}
                            @else
                                {{ __('common.Add') }}
                            @endif  {{__('survey.Answer')}} </h3>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            @if (isset($edit))
                                <form method="POST" action="{{ route('survey.set_attribute_update') }}"
                                      accept-charset="UTF-8" class="form-horizontal" enctype="multipart/form-data">
                                    <input type="hidden" name="id" value="{{$edit->id}}">
                                    @else
                                        <form method="POST"
                                              action="{{ route('survey.set_attribute_store',$set_info->id) }}"
                                              accept-charset="UTF-8" class="form-horizontal"
                                              enctype="multipart/form-data">
                                            <input type="hidden" name="set_id" value="{{$set_info->id}}">
                                            @endif

                                            @csrf
                                            <div class="white-box">
                                                <div class="add-visitor">
                                                    <div class="row">
                                                        <div class="col-lg-12">
                                                            <div class="input-effect">
                                                                <label class="primary_input_label mt-1">Name <span class="text-danger">*</span></label>
                                                                <input class="primary_input_field" type="text"
                                                                       name="name" autocomplete="off"
                                                                       value="{{ isset($edit) ? $edit->name: old('name')}}">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row mt-40">
                                                        <div class="col-lg-12 text-center">
                                                            <button type="submit" class="primary-btn fix-gr-bg"
                                                                    data-bs-toggle="tooltip" title=""><span
                                                                    class="ti-check"></span> Save
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                        </div>
                    </div>
                </div>
                <div class="col-lg-9">

                    <div class="main-title">
                        <h3 class="mb-20">{{__('survey.Answer')}}</h3>
                    </div>

                    <div class="QA_section QA_section_heading_custom check_box_table">
                        <div class="QA_table ">
                            <!-- table-responsive -->
                            <div class="">
                                <table id="lms_table" class="table Crm_table_active3">
                                    <thead>
                                    <tr>
                                        <th scope="col">{{__('common.SL')}}</th>
                                        <th scope="col">{{__('common.Name')}}</th>
                                        <th scope="col">{{__('common.Status')}}</th>
                                        <th scope="col">{{__('common.Action')}}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($set_info->attributes as $index => $attribute)
                                        <tr>
                                            <td scope="col">{{ $index+1 }}</td>
                                            <td scope="col">{{ $attribute->name }}</td>
                                            <td class="nowrap">
                                                @if (Auth::user()->role_id==1)
                                                    <label class="switch_toggle ml-20" for="status{{$attribute->id}}">
                                                        <input type="checkbox" class="status_enable_disable"
                                                               name="status" id="status{{$attribute->id}}"
                                                               {{$attribute->status==1? 'checked':''}}  value="{{$attribute->id}}">
                                                        <i class="slider round"></i>
                                                    </label>
                                                @else
                                                    @if ($attribute->status==1)
                                                        Enabled
                                                    @else
                                                        Disabled

                                                    @endif
                                                @endif
                                            </td>
                                            <td scope="col">
                                                <div class="dropdown CRM_dropdown">
                                                    <button class="btn btn-secondary dropdown-toggle" type="button"
                                                            id="dropdownMenu2" data-bs-toggle="dropdown"
                                                            aria-haspopup="true" aria-expanded="false">
                                                        Action
                                                    </button>
                                                    <div class="dropdown-menu dropdown-menu-right"
                                                         aria-labelledby="dropdownMenu2" style="">
                                                        <a href="{{ route('survey.attribute_edit', [$attribute->set_id,$attribute->id]) }}"
                                                           class="dropdown-item editStudent"
                                                           type="button">{{__('common.Edit')}}</a>
                                                        @if (permissionCheck('survey.set_attribute_delete'))
                                                            <a onclick="confirm_modal('{{route('survey.set_attribute_delete', $attribute->id)}}');"
                                                               class="dropdown-item edit_brand">{{__('common.Delete')}}</a>
                                                        @endif

                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Add Modal Item_Details -->
            </div>
        </div>
    </section>
    <input type="hidden" name="status_route" class="status_route" value="{{ route('coupons.status_update') }}">

    @include('backend.partials.delete_modal')
@endsection

