<?php

namespace Modules\Survey\Http\Controllers;

use App\User;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Survey\Entities\Survey;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Support\Facades\Auth;
use Modules\Survey\Entities\SurveyAssign;
use Modules\Survey\Entities\SurveyQuestion;
use Illuminate\Contracts\Support\Renderable;
use Modules\Survey\Entities\SurveyAnswerSubmit;
use Modules\Survey\Entities\SurveyQuestionBank;

class UserSurveyController extends Controller
{
    public function index()
    {
        $surveys = SurveyAssign::where('user_id', Auth::user()->id)->whereHas('survey', function ($query) {
            $query->where('status', 1);
        })->with('survey')->get();

        return view('survey::my_survey', compact('surveys'));
    }


    public function create()
    {
        return view('survey::create');
    }


    public function store(Request $request)
    {

        $assign_info = SurveyAssign::where('id', $request->assign_id)->where('user_id', Auth::user()->id)->first();
        if (!$assign_info) {
            Toastr::error('You Are not assigned for this survey', trans('common.Failed'));
            return redirect()->back();
        }
        try {
            foreach ($request->question as $key => $question) {
                if (gettype($request->survey_answer[$question]) == "array") {
                    foreach ($request->survey_answer[$question] as $ans) {
                        $answer = new SurveyAnswerSubmit();
                        $answer->assign_id = $request->assign_id;
                        $answer->survey_id = $assign_info->survey_id;
                        $answer->user_id = Auth::user()->id;
                        $answer->question_id = $question;
                        $answer->answer = $ans;
                        $answer->save();
                    }
                } else {
                    $answer = new SurveyAnswerSubmit();
                    $answer->assign_id = $request->assign_id;
                    $answer->survey_id = $assign_info->survey_id;
                    $answer->user_id = Auth::user()->id;
                    $answer->question_id = $question;
                    $answer->answer = $request->survey_answer[$question];
                    $answer->save();
                }

            }
            $assign_info->is_attended = 1;
            $assign_info->save();
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->back();
        } catch (\Throwable $th) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }

    public function show($id)
    {
        $assign = SurveyAssign::where('id', $id)->where('user_id', Auth::user()->id)->first();
        $submitted_answers = SurveyAnswerSubmit::where('user_id', Auth::user()->id)->where('assign_id', $id)->get();
        return view('survey::survey_participate', compact('assign', 'submitted_answers'));
    }

    public function surveyParticipants($survey_id)
    {
        $survey_info = Survey::find($survey_id);
        return view('survey::participants', compact('survey_info'));
    }

    public function surveyParticipantsView($survey_id, $user_id)
    {
        $survey = Survey::findOrFail($survey_id);
        $user = User::findOrFail($user_id);
        $submitted_answers = SurveyAnswerSubmit::where('user_id', $user_id)->get();
        return view('survey::survey_participate', compact('survey', 'user', 'submitted_answers'));
    }

    public function userBasedReport($survey_id)
    {
        $survey = Survey::find($survey_id);
        return view('survey::report.user_wise_report', compact('survey'));
    }

    public function questionBasedReport($survey_id)
    {
        $survey = Survey::find($survey_id);
        // return $survey->questions;
        return view('survey::report.question_wise_report', compact('survey'));
    }

    public function questionBasedReportSearch(Request $request, $survey_id)
    {
        $survey = Survey::find($survey_id);
        $submitted_answers = SurveyAnswerSubmit::where('question_id', $request->question_id)->get();
        $selected_question = SurveyQuestionBank::find($request->question_id);
        return view('survey::report.question_wise_report', compact('survey', 'submitted_answers', 'selected_question'));
    }

    public function userBasedReportSearch(Request $request, $survey_id)
    {
        $survey = Survey::find($survey_id);
        $submitted_answers = SurveyAnswerSubmit::where('survey_id', $survey_id)->where('user_id', $request->user_id)->get();

        return view('survey::report.user_wise_report', compact('survey', 'submitted_answers'));
    }


    public function edit($id)
    {
        return view('survey::edit');
    }

}
