@extends('backend.master')
@push('styles')

@endpush
@php
    $table_name='course_subscriptions';
@endphp
@section('table')
    {{$table_name}}
@endsection

@section('mainContent')

    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="white-box">

                <div class="row justify-content-center">
                    <div class="col-12">
                        <div class="box_header common_table_header">
                            <div class="main-title d-md-flex">
                                <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px" id="page_title">{{__('subscription.Plan List')}}</h3>

                                <ul class="d-flex">
                                    <li><a class="primary-btn radius_30px   fix-gr-bg" data-bs-toggle="modal"
                                           id="add_plan_btn"
                                           data-bs-target="#add_plan" href="#"><i
                                                class="ti-plus"></i>{{__('subscription.Add Plan')}}</a></li>
                                </ul>

                            </div>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <!-- table-responsive -->
                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <th>#</th>
                                            <th scope="col">{{__('subscription.Title')}}</th>
                                            <th scope="col">{{__('courses.Categories')}}</th>
                                            <th scope="col">{{__('subscription.Price')}}</th>
                                            <th scope="col">{{__('subscription.About')}}</th>
                                            <th scope="col">{{__('subscription.Button Text')}}</th>
                                            <th scope="col">{{__('subscription.Days')}}</th>
                                            @if(currentTheme()=='tvt')
                                                <th scope="col">{{__('common.Popular')}}</th>
                                            @endif
                                            <th scope="col">{{__('common.Status')}}</th>
                                            <th scope="col">{{__('common.Action')}}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($plans as $key => $plan)
                                            <tr data-item="{{$plan->id}}">
                                                <td>
                                                    <i class="ti-menu"></i>
                                                </td>

                                                <td>{{@$plan->title}}</td>
                                                <td>
                                                    @if($plan->category_id>1)
                                                        {{@$plan->category->name}}
                                                    @else
                                                        {{__('common.All')}}
                                                    @endif
                                                </td>
                                                <td>{{getPriceFormat($plan->price)}}</td>
                                                <td>{{@$plan->about}}</td>
                                                <td>{{@$plan->btn_txt}}</td>
                                                <td>{{@translatedNumber($plan->days)}}</td>
                                                @if(currentTheme()=='tvt')
                                                    <td class="nowrap">
                                                        <label class="switch_toggle"
                                                               for="popular_checkbox{{@$plan->id }}">
                                                            <input type="checkbox"
                                                                   class="changePopular"
                                                                   data-id="{{@$plan->id}}"
                                                                   data-status="{{@$plan->popular}}"
                                                                   id="popular_checkbox{{@$plan->id }}"
                                                                   @if (@$plan->popular == 1) checked
                                                                   @endif value="{{@$plan->id }}">
                                                            <i class="slider round"></i>
                                                        </label>
                                                    </td>
                                                @endif
                                                <td class="nowrap">
                                                    <label class="switch_toggle">
                                                        <input type="checkbox"
                                                               class="@if (permissionCheck('subscription.change_status')) status_enable_disable @endif "
                                                               @if (@$plan->status == 1) checked
                                                               @endif value="{{@$plan->id }}">
                                                        <i class="slider round"></i>
                                                    </label>
                                                </td>

                                                <td>
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu2" data-bs-toggle="dropdown"
                                                                aria-haspopup="true"
                                                                aria-expanded="false">
                                                            {{__('common.Action')}}
                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu2">
                                                            @if (permissionCheck('subscription.edit'))
                                                                <button data-item="{{$plan}}"
                                                                        class="dropdown-item editplan"
                                                                        type="button">{{__('common.Edit')}}</button>
                                                            @endif

                                                            @if ($setting->type==2)
                                                                <a href="{{route('assignCourseToPlan')}}?id={{$plan->id}}"
                                                                   class="dropdown-item"
                                                                >{{__('subscription.Add course')}}</a>
                                                            @endif

                                                            @if (permissionCheck('subscription.delete'))
                                                                <button class="dropdown-item deleteplan"
                                                                        data-id="{{$plan->id}}"
                                                                        type="button">{{__('common.Delete')}}</button>
                                                            @endif
                                                            <a href="{{route('subscription.planFeature.index')}}?id={{$plan->id}}"
                                                               class="dropdown-item"
                                                            >{{__('subscription.Plan Feature')}}</a>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>

                                        @endforeach
                                        @if(count($plans)==0)
                                            <tr>
                                                <td class="text-center" colspan="10">
                                                    {{__("common.No data available in the table")}}
                                                </td>
                                            </tr>
                                        @endif
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Add Modal Item_Details -->
                    <div class="modal fade admin-query" id="add_plan">
                        <div class="modal-dialog modal_1000px modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">{{__('subscription.Add Plan')}}</h4>
                                    <button type="button" class="close " data-bs-dismiss="modal">
                                        <i class="ti-close "></i>
                                    </button>
                                </div>

                                <div class="modal-body">
                                    <form action="{{route('subscription.plan.store')}}" method="POST"
                                          enctype="multipart/form-data">
                                        @csrf
                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for="">{{__('subscription.Title')}}
                                                        <strong class="text-danger">*</strong></label>
                                                    <input class="primary_input_field" name="title" placeholder="-"
                                                           required
                                                           type="text" id="addTitle"
                                                           value="{{ old('title') }}" {{$errors->first('title') ? 'autofocus' : ''}}>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-xl-12">
                                                <label class="primary_input_label d-flex"
                                                       for="">{{__('courses.Category')}}
                                                </label>
                                                <select class="primary_select category_id mb-25" name="category"
                                                        id="category_id" {{$errors->has('category') ? 'autofocus' : ''}}>
                                                    <option
                                                        data-display="{{__('common.Select')}} {{__('quiz.Category')}}"
                                                        value="">{{__('common.Select')}} {{__('quiz.Category')}} <span
                                                            class="required_mark">*</span></option>
                                                    @foreach($categories as $category)
                                                        @if($category->parent_id==0)
                                                            @include('backend.categories._single_select_option',['category'=>$category,'level'=>1])
                                                        @endif
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for="">{{__('subscription.Price')}} <strong
                                                            class="text-danger">*</strong></label>
                                                    <input class="primary_input_field" name="price" placeholder="0"
                                                           required
                                                           type="number" min="1" id="addPrice" step="any"
                                                           value="{{ old('price') }}" {{$errors->first('price') ? 'autofocus' : ''}}>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for="">{{__('subscription.Days')}} <strong
                                                            class="text-danger">*</strong></label>
                                                    <input class="primary_input_field" name="days" placeholder="0"
                                                           required
                                                           type="number" min="1" id="addDays"
                                                           value="{{ old('days') }}" {{$errors->first('days') ? 'autofocus' : ''}}>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for="">{{__('subscription.About')}} </label>
                                                    <input class="primary_input_field" name="about" placeholder="-"

                                                           type="text" id="addAbout"
                                                           value="{{ old('about') }}" {{$errors->first('about') ? 'autofocus' : ''}}>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for="">{{__('subscription.Button Text')}} <strong
                                                            class="text-danger">*</strong></label>
                                                    <input class="primary_input_field" name="btn_txt" placeholder="-"

                                                           type="text" id="addBtn"
                                                           value="{{ old('btn_txt') }}" {{$errors->first('btn_txt') ? 'autofocus' : ''}}>
                                                </div>
                                            </div>
                                        </div>
                                        @if(currentTheme()=='tvt')
                                            <div class="row">
                                                <div class="col-xl-12">
                                                    <div class="primary_input ">
                                                        <div class="row">
                                                            <div class="col-md-12 ">
                                                                <label class="primary_input_label"
                                                                       for=""> {{__('subscription.Is Recurring')}}
                                                                    * </label>
                                                            </div>

                                                            <div class="col-md-1 mb-25">
                                                                <label class="primary_checkbox d-flex mr-12">
                                                                    <input type="radio" id=""
                                                                           name="is_recurring"
                                                                           value="0"
                                                                           @if(empty(old('is_recurring')))checked @else
                                                                        {{old('is_recurring')==0?"checked":""}}
                                                                        @endif
                                                                    >
                                                                    <span
                                                                        class="checkmark me-2"></span> {{__('common.No')}}
                                                                </label>
                                                            </div>

                                                            <div class="col-md-1 mb-25">
                                                                <label class="primary_checkbox d-flex mr-12">
                                                                    <input type="radio" id=""
                                                                           name="is_recurring"
                                                                           value="1"
                                                                        {{old('is_recurring')==1?"checked":""}}
                                                                    >
                                                                    <span
                                                                        class="checkmark me-2"></span>{{__('common.Yes')}}
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                        <div class="col-lg-12 text-center pt_15">
                                            <div class="d-flex justify-content-center">
                                                <button class="primary-btn semi_large2  fix-gr-bg"
                                                        id="save_button_parent"
                                                        type="submit"><i
                                                        class="ti-check"></i> {{__('common.Save')}} {{__('subscription.Plan')}}
                                                </button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="modal fade admin-query" id="editplan">
                        <div class="modal-dialog modal_1000px modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">{{__('subscription.Update Plan')}}</h4>
                                    <button type="button" class="close " data-bs-dismiss="modal">
                                        <i class="ti-close "></i>
                                    </button>
                                </div>

                                <div class="modal-body">
                                    <form action="{{route('subscription.plan.update')}}" method="POST"
                                          enctype="multipart/form-data">
                                        @csrf
                                        <input type="hidden" name="id" value="{{old('id')}}" id="planId">
                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for="">{{__('subscription.Title')}} <strong
                                                            class="text-danger">*</strong></label>
                                                    <input class="primary_input_field" name="title" placeholder="-"
                                                           required
                                                           type="text" id="editTitle"
                                                           value="{{ old('title') }}" {{$errors->first('title') ? 'autofocus' : ''}}>
                                                </div>
                                            </div>


                                        </div>
                                        <div class="row">
                                            <div class="col-xl-12">
                                                <label class="primary_input_label d-flex"
                                                       for="">{{__('courses.Category')}}
                                                </label>
                                                <select class="primary_select category_id mb-25" name="category"
                                                        id="category_id_edit" {{$errors->has('category') ? 'autofocus' : ''}}>
                                                    <option
                                                        data-display="{{__('common.Select')}} {{__('quiz.Category')}}"
                                                        value="">{{__('common.Select')}} {{__('quiz.Category')}} <span
                                                            class="required_mark">*</span></option>
                                                    @foreach($categories as $category)
                                                        @if($category->parent_id==0)
                                                            @include('backend.categories._single_select_option',['category'=>$category,'level'=>1])
                                                        @endif
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for="">{{__('subscription.Price')}} <strong
                                                            class="text-danger">*</strong></label>
                                                    <input class="primary_input_field" name="price" placeholder="-"
                                                           required
                                                           type="number" id="editPrice" min="1" step="any"
                                                           value="{{ old('price') }}" {{$errors->first('price') ? 'autofocus' : ''}}>
                                                </div>
                                            </div>


                                        </div>

                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for="">{{__('subscription.Days')}} <strong
                                                            class="text-danger">*</strong></label>
                                                    <input class="primary_input_field" name="days" placeholder="-"
                                                           required
                                                           type="number" id="editDays" min="1"
                                                           value="{{ old('days') }}" {{$errors->first('days') ? 'autofocus' : ''}}>
                                                </div>
                                            </div>


                                        </div>

                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for="">{{__('subscription.About')}} <strong
                                                            class="text-danger">*</strong></label>
                                                    <input class="primary_input_field" name="about" placeholder="-"
                                                           required
                                                           type="text" id="editAbout"
                                                           value="{{ old('about') }}" {{$errors->first('about') ? 'autofocus' : ''}}>
                                                </div>
                                            </div>


                                        </div>
                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for="">{{__('subscription.Button Text')}} <strong
                                                            class="text-danger">*</strong></label>
                                                    <input class="primary_input_field" name="btn_txt" placeholder="-"
                                                           required
                                                           type="text" id="editBtnTxt"
                                                           value="{{ old('btn_txt') }}" {{$errors->first('btn_txt') ? 'autofocus' : ''}}>
                                                </div>
                                            </div>
                                        </div>
                                        @if(currentTheme()=='tvt')
                                            <div class="row">
                                                <div class="col-xl-12">
                                                    <div class="primary_input ">
                                                        <div class="row">
                                                            <div class="col-md-12 ">
                                                                <label class="primary_input_label"
                                                                       for=""> {{__('subscription.Is Recurring')}}
                                                                    * </label>
                                                            </div>

                                                            <div class="col-md-1 mb-25">
                                                                <label class="primary_checkbox d-flex mr-12">
                                                                    <input type="radio" id=""
                                                                           name="is_recurring"
                                                                           value="0"
                                                                           @if(empty(old('is_recurring')))checked @else
                                                                        {{old('is_recurring')==0?"checked":""}}
                                                                        @endif
                                                                    >
                                                                    <span
                                                                        class="checkmark me-2"></span> {{__('common.No')}}
                                                                </label>
                                                            </div>

                                                            <div class="col-md-1 mb-25">
                                                                <label class="primary_checkbox d-flex mr-12">
                                                                    <input type="radio" id=""
                                                                           name="is_recurring"
                                                                           value="1"
                                                                        {{old('is_recurring')==1?"checked":""}}
                                                                    >
                                                                    <span
                                                                        class="checkmark me-2"></span>{{__('common.Yes')}}
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif

                                        <div class="col-lg-12 text-center pt_15">
                                            <div class="d-flex justify-content-center">
                                                <button class="primary-btn semi_large2  fix-gr-bg"
                                                        id="save_button_parent" type="submit"><i
                                                        class="ti-check"></i> {{__('subscription.Update Plan')}}
                                                </button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal fade admin-query" id="deleteplan">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">{{__('common.Delete')}} {{__('subscription.Plan')}} </h4>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"><i
                                            class="ti-close "></i></button>
                                </div>

                                <div class="modal-body">
                                    <form action="{{route('subscription.plan.destroy')}}" method="post">
                                        @csrf

                                        <div class="text-center">

                                            <h4>{{__('common.Are you sure to delete ?')}} </h4>
                                        </div>
                                        <input type="hidden" name="id" value="" id="planDeleteId">
                                        <div class="mt-40 d-flex justify-content-between">
                                            <button type="button" class="primary-btn tr-bg"
                                                    data-bs-dismiss="modal">{{__('common.Cancel')}}</button>

                                            <button class="primary-btn fix-gr-bg"
                                                    type="submit">{{__('common.Delete')}}</button>

                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>

@endsection
@push('scripts')

    @include('subscription::plan.script')
@endpush

