@extends('backend.master')
@push('styles')
    @include('subscription::assign.style')
@endpush
@php
    $table_name='';
@endphp
@section('table')
    {{$table_name}}
@endsection

@section('mainContent')

    {!! generateBreadcrumb() !!}


    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row row-gap-24">
                <div class="col-lg-4">
                    <div class="white-box">
                        <div class="row m-0">
                            <div class="col-lg-12 p-0">
                                <div class="main-title">
                                    <h3 class="mb-20">
                                        @lang('common.Add') @lang('subscription.Course')
                                    </h3>
                                </div>
                                <div class="row m-0">
                                    <div class="col-lg-12 card pt-4 pb-4">
                                        <div id="accordion">
                                            <div class="card mt-10">
                                                <div class="card-header" id="courses">
                                                    <h5 class="mb-0 collapsed create-title" data-bs-toggle="collapse"
                                                        data-bs-target="#coursePage"
                                                        aria-expanded="false" aria-controls="coursePage">
                                                        <button class="btn btn-link cust-btn-link add_btn_link">
                                                            @lang('frontendmanage.Courses')
                                                        </button>
                                                    </h5>
                                                </div>
                                                <div id="coursePage" class="collapse show" aria-labelledby="courses"
                                                     aria-expanded="true" data-parent="#accordion">
                                                    <div class="card-body">
                                                        <div class="row">
                                                            <div class="col-lg-12">
                                                                <div class="primary_input mb-15">

                                                                    <select name="courses[]" id="courseInput" required
                                                                            class="primary_multiselect mb-15 e1" multiple>
                                                                        @foreach ($courses as $key => $course)
                                                                            <option
                                                                                value="{{ $course->id }}">{{ $course->title }}</option>
                                                                        @endforeach
                                                                    </select>
                                                                    <div class="row">
                                                                        <div class="col-lg-5">
                                                                            <input type="checkbox" id="coursesCheckbox"
                                                                                   class="common-checkbox">
                                                                            <label for="coursesCheckbox"
                                                                                   class="mt-3">@lang('frontendmanage.Select All')</label>
                                                                        </div>
                                                                        <div class="col-lg-7">
                                                                            <button id="add_course_page_btn" type="submit"
                                                                                    class="primary-btn small fix-gr-bg  mt-3  submit_btn"
                                                                                    data-bs-toggle="tooltip"
                                                                                    title="" data-original-title="">
                                                                                <i class="ti-check"></i>
                                                                                @lang('common.Add')
                                                                            </button>
                                                                        </div>
                                                                    </div>
                                                                    <span class="text-danger"></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>


                                            <div class="card">
                                                <div class="card-header" id="quizzes">
                                                    <h5 class="mb-0 collapsed create-title" data-bs-toggle="collapse"
                                                        data-bs-target="#quizPages"
                                                        aria-expanded="false" aria-controls="quizPages">
                                                        <button class="btn btn-link cust-btn-link add_btn_link">
                                                            @lang('frontendmanage.Quizzes')
                                                        </button>
                                                    </h5>
                                                </div>
                                                <div id="quizPages" class="collapse" aria-labelledby="quizzes"
                                                     data-parent="#accordion">
                                                    <div class="card-body">
                                                        <div class="row">
                                                            <div class="col-lg-12">
                                                                <div class="primary_input mb-15">

                                                                    <select name="quiz[]" id="quizInput" required
                                                                            class=" primary_multiselect mb-15 e1" multiple>
                                                                        @foreach ($quizzes as $key => $quiz)
                                                                            <option
                                                                                value="{{ $quiz->id }}">{{ $quiz->title }}</option>
                                                                        @endforeach
                                                                    </select>
                                                                    <div class="row">
                                                                        <div class="col-lg-5">
                                                                            <input type="checkbox" id="quizCheckbox"
                                                                                   class="common-checkbox">
                                                                            <label for="quizCheckbox"
                                                                                   class="mt-3">@lang('frontendmanage.Select All')</label>
                                                                        </div>
                                                                        <div class="col-lg-7">
                                                                            <button id="add_quiz_page_btn" type="submit"
                                                                                    class="primary-btn small fix-gr-bg  mt-3   submit_btn"
                                                                                    data-bs-toggle="tooltip"
                                                                                    title="" data-original-title="">
                                                                                <i class="ti-check"></i>
                                                                                @lang('common.Add')
                                                                            </button>
                                                                        </div>
                                                                    </div>
                                                                    <span class="text-danger"></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>


                                            <div class="card">
                                                <div class="card-header" id="liveClass">
                                                    <h5 class="mb-0 collapsed create-title" data-bs-toggle="collapse"
                                                        data-bs-target="#liveClassPage"
                                                        aria-expanded="false" aria-controls="liveClassPage">
                                                        <button class="btn btn-link cust-btn-link add_btn_link">
                                                            @lang('frontendmanage.Live Class')
                                                        </button>
                                                    </h5>
                                                </div>
                                                <div id="liveClassPage" class="collapse" aria-labelledby="liveClass"
                                                     data-parent="#accordion">
                                                    <div class="card-body">
                                                        <div class="row">
                                                            <div class="col-lg-12">
                                                                <div class="primary_input mb-15">

                                                                    <select name="class[]" id="classInput" required
                                                                            class="primary_multiselect  mb-15 e1"
                                                                            multiple="multiple">
                                                                        @foreach ($classes as $key => $class)
                                                                            <option
                                                                                value="{{ $class->id }}">{{ $class->title }}</option>
                                                                        @endforeach
                                                                    </select>
                                                                    <div class="row">
                                                                        <div class="col-lg-5">
                                                                            <input type="checkbox" id="classCheckbox"
                                                                                   class="common-checkbox">
                                                                            <label for="classCheckbox"
                                                                                   class="mt-3">@lang('frontendmanage.Select All')</label>
                                                                        </div>
                                                                        <div class="col-lg-7">
                                                                            <button id="add_class_page_btn" type="submit"
                                                                                    class="primary-btn small fix-gr-bg mt-3 submit_btn"
                                                                                    data-bs-toggle="tooltip"
                                                                                    title="" data-original-title="">
                                                                                <i class="ti-check"></i>
                                                                                @lang('common.Add')
                                                                            </button>
                                                                        </div>
                                                                    </div>
                                                                    <span class="text-danger"></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>


                                        </div>
                                    </div>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-8">
                    <div class="white-box">
                        <div class="row">
                            <div class="col-lg-4 ">
                                <div class="main-title">
                                    <h3 class="mb-20">@lang('subscription.Course List')</h3>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12" id="courseList">
                                @include('subscription::assign.list')
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade admin-query" id="deleteSubmenuItem">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">@lang('common.Delete') </h4>
                        <button type="button" class="btn-close" data-bs-dismiss="modal">&times;</button>
                    </div>
                    <div class="modal-body">
                        <div class="text-center">
                            <h4>@lang('common.Are you sure to delete ?')</h4>
                        </div>
                        <div class="mt-40 d-flex justify-content-between">
                            <button type="button" class="primary-btn tr-bg"
                                    data-bs-dismiss="modal">@lang('common.Cancel')</button>
                            <input type="hidden" name="id" id="item-delete" value="">
                            <a class="primary-btn fix-gr-bg" id="delete-item" href="#">@lang('common.Delete')</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <input type="hidden" id="subscription_reordering_url" value="{{route('subscription.course.reordering')}}">
        <input type="hidden" id="subscription_delete_url" value="{{ route('subscription.course.delete') }}">
        <input type="hidden" id="course_add_url" value="{{route('subscription.course.add-element')}}">
        <input type="hidden" id="plan_id" value="{{$plan->id}}">
        <input type="hidden" id="header_token" value="{{csrf_token()}}">

    </section>
@endsection
@push('scripts')

    @include('subscription::assign.script')
@endpush

