<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Modules\Subscription\Entities\SubscriptionSetting;

class CreateSubscriptionSettingsTable extends Migration
{

    public function up()
    {
        Schema::create('subscription_settings', function (Blueprint $table) {
            $table->id();
            $table->integer('commission_rate')->default(50);
            $table->integer('type')->default(1);
            $table->integer('lms_id')->default(1);
            $table->timestamps();
        });

        DB::table('subscription_settings')->insert(
            [
                'commission_rate' => 50,
                'type' => 1
            ]
        );

    }


    public function down()
    {
        Schema::dropIfExists('subscription_settings');
    }
}
