@extends('backend.master')

@php
    $table_name = 'products';

@endphp

@php
    $date = request()->get('date');
    $order_status = request()->get('order_status');
    $url = route('getAllOrder')."?date={$date}&order_status={$order_status}";
@endphp

@section('table')
    {{ $table_name }}
@stop
@section('mainContent')
    {!! generateBreadcrumb() !!}
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">

            <div class="white-box">
                <div class="row justify-content-center">
                    <div class="box_header common_table_header">
                        <div class="main-title d-md-flex mb-0">
                            <h3 class="mb-0" id="page_title">{{ __('product.Orders') }}</h3>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table">
                                <div class="">
                                    <table id="lms_table" class="table classList">
                                        <thead>
                                        <tr>
                                            <th scope="col"> {{ __('common.SL') }}</th>
                                            <th scope="col"> {{ __('product.Order ID') }}</th>
                                            <th scope="col"> {{ __('product.Customer') }}</th>
                                            <th scope="col"> {{ __('product.Seller/Instructor') }}</th>
                                            <th scope="col"> {{ __('product.Total Product Quantity') }}</th>
                                            <th scope="col"> {{ __('product.Total Amount') }}</th>
                                            <th scope="col"> {{ __('product.Discount') }}</th>
                                            <th scope="col"> {{ __('common.Date') }}</th>
                                            <th scope="col">{{ __('product.Order Status') }}</th>
                                            <th scope="col">{{ __('product.Is Paid') }}</th>
                                            <th scope="col">{{ __('common.Action') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>

                                        </tbody>
                                    </table>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>


        </div>
    </section>

    @include('store::partials.delete_modal')

@endsection
@push('scripts')

    <script>
        (function ($) {
            "use strict";
            dataTableOptions.serverSide = true
            dataTableOptions.processing = true
            dataTableOptions.ajax = '{!! $url !!}';
            dataTableOptions.columns = [{
                data: 'DT_RowIndex',
                name: 'id'
            },
                {
                    data: 'order_number',
                    name: 'order_number'
                },
                {
                    data: 'customer',
                    name: 'customer'
                },
                {
                    data: 'instructor',
                    name: 'instructor'
                },
                {
                    data: 'quantity',
                    name: 'quantity'
                },
                {
                    data: 'price',
                    name: 'price'
                },
                {
                    data: 'discount',
                    name: 'discount'
                },
                {
                    data: 'date',
                    name: 'date'
                },
                {
                    data: 'status',
                    name: 'status'
                },
                {
                    data: 'is_paid',
                    name: 'is_paid'
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false
                },
            ];
            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2, 3, 4, 5, 6, 7, 9]);

            $('#lms_table').DataTable(dataTableOptions);

        })(jQuery);

    </script>
@endpush
