<?php

namespace Modules\Store\Http\Controllers;

use App\Http\Controllers\Frontend\WebsiteController;
use Brian2694\Toastr\Facades\Toastr;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Modules\CourseSetting\Entities\Course;
use Modules\CourseSetting\Entities\CourseComment;
use Modules\CourseSetting\Entities\CourseEnrolled;
use Modules\FrontendManage\Entities\FrontPage;
use Modules\Payment\Entities\Cart;
use Modules\Store\Entities\ProductSku;

class FrontendStoreController extends Controller
{


    public function __construct()
    {
        $this->middleware('maintenanceMode');
    }


    public function products(Request $request)
    {
        try {
            if (hasDynamicPage()) {
                $row = FrontPage::where('slug', '/store')->first();
                $details = dynamicContentAppend($row->details);
                return view('aorapagebuilder::pages.show', compact('row', 'details'));
            } else {
                return view(theme('pages.products'), compact('request'));
            }

        } catch (Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }

    public function productDetails($slug, Request $request)
    {
        try {
            $is_cart = 0;
            $course = Course::with('product.category', 'product.product_image', 'product_category', 'enrollUsers', 'user', 'user.courses', 'user.courses.enrollUsers', 'user.courses.lessons', 'chapters.lessons', 'enrolls', 'lessons', 'reviews', 'chapters', 'activeReviews')
                ->where('slug', $slug)->first();
            if (!$course) {
                Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
                return redirect()->back();
            }

            if (!isViewable($course)) {
                Toastr::error(trans('common.Access Denied'), trans('common.Failed'));
                return redirect()->to(route('courses'));
            }
            if (Auth::check()) {
                $isEnrolled = $course->isLoginUserEnrolled;
            } else {
                $isEnrolled = false;
            }

            if ($isEnrolled) {
                $enroll = CourseEnrolled::where('user_id', Auth::id())->where('course_id', $course->id)->first();
                if ($enroll) {
                    if ($enroll->subscription == 1) {
                        if (isModuleActive('Subscription')) {
                            if (!isSubscribe()) {
                                Toastr::error(trans('frontend.Subscription has expired, Please Subscribe again'),trans('common.Failed'));
                                return redirect()->route('courseSubscription');
                            }
                        }
                    }
                }
            }

            $data = '';
            if ($request->ajax()) {
                if ($request->type == "comment") {
                    $comments = CourseComment::where('course_id', $course->id)->with('replies', 'replies.user', 'user')->paginate(10);
                    foreach ($comments as $comment) {
                        $data .= view(theme('partials._single_comment'), ['comment' => $comment, 'isEnrolled' => $isEnrolled, 'course' => $course])->render();
                    }
                    return $data;
                }

            }


            if ($request->ajax()) {
                if ($request->type == "review") {
                    $reviews = DB::table('course_reveiws')
                        ->select(
                            'course_reveiws.id',
                            'course_reveiws.star',
                            'course_reveiws.comment',
                            'course_reveiws.instructor_id',
                            'course_reveiws.created_at',
                            'users.id as userId',
                            'users.name as userName',
                        )
                        ->join('users', 'users.id', '=', 'course_reveiws.user_id')
                        ->where('course_reveiws.status',1)
                        ->where('course_reveiws.course_id', $course->id)->paginate(10);
                    foreach ($reviews as $review) {
                        $data .= view(theme('partials._single_review'), ['review' => $review, 'isEnrolled' => $isEnrolled, 'course' => $course])->render();
                    }
                    if (count($reviews) == 0) {
                        $data .= '';
                    }
                    return $data;
                }
            }


            $course->view = $course->view + 1;
            $course->save();

            if ($course->host == "VdoCipher") {
                $websiteController = new WebsiteController();
                $otp = $websiteController->getOTPForVdoCipher($course->trailer_link);
                $course->otp = $otp['otp'];
                $course->playbackInfo = $otp['playbackInfo'];
            }

            return view(theme('pages.productDetails'), compact('request', 'course', 'isEnrolled'));


        } catch (Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }

    public function get_product_sku_wise_price(Request $request)
    {
        $array = [];
        $attribute_values = $request->get('attribute_values',[]);

        $query =  ProductSku::query();

        foreach ($attribute_values as $attribute_value){
            $query->where('product_id', $request->get('product_id'))
                ->whereHas('product_variations', function($query) use ($attribute_value){
                $query->where('attribute_value_id',$attribute_value);
            });
        }
        $suk =$query->first();

        if($suk){
            $array['price'] = showPrice($suk->price);
            $array['sku_id'] = $suk->id;
        }
        return $array;
    }

    public function update_product_qty_in_cart(Request $request)
    {
        $cart =Cart::where('course_id',$request->course_id)->where('is_store',1)->first();
        if ($cart){
            $qty = $request->total;
            $sku =ProductSku::find($cart->product_sku_id);
            $cart->qty =$qty;
            $cart->price =$sku->price*$qty;
            $cart->save();
        }else{
            return [
                'success' => false,
            ];
        }
        return [
            'success' => true,
            'qty' => $cart->qty??0,
            'price' => $cart->price??0,
        ];
    }
}
