<?php

namespace Modules\Store\Entities;

use App\User;
use Illuminate\Database\Eloquent\Model;
use Modules\Setting\Entities\UsedMedia;
use App\Traits\HasTranslations;

class ProductCategory extends Model
{
    use HasTranslations;

    protected $guarded = ['id'];
    public $translatable = ['title'];


    public function user()
    {
        return $this->belongsTo(User::class)->withDefault();
    }

    public function subcategories()
    {

        return $this->hasMany(ProductCategory::class, 'parent_id', 'id')->select('id', 'parent_id', 'title')->orderBy('position_order');
    }

    public function parent()
    {
        return $this->belongsTo(ProductCategory::class, 'parent_id')->with('parent')->withDefault();
    }

    public function childs()
    {
        return $this->hasMany(ProductCategory::class, 'parent_id')->with('childs');
    }

    public function products()
    {
        return $this->hasMany(Product::class, 'category_id', 'id')->where('status', 1);
    }

    public function image_media()
    {
        return $this->morphOne(UsedMedia::class, 'usable')->where('used_for', 'image');
    }

}
