<?php

namespace Modules\Store\Entities;

use App\User;
use Illuminate\Database\Eloquent\Model;
use Modules\CourseSetting\Entities\Course;
use Modules\Setting\Entities\UsedMedia;
use App\Traits\HasTranslations;
use stdClass;

class Product extends Model
{
    use  HasTranslations;

    public $translatable = ['title', 'description', 'specification', 'faq'];
    protected $table = "products";
    protected $guarded = ['id'];

    public function user()
    {
        return $this->belongsTo(User::class)->withDefault();
    }

    public function category()
    {

        return $this->belongsTo(ProductCategory::class, 'category_id', 'id')->withDefault();
    }

    public function subCategory()
    {

        return $this->belongsTo(ProductCategory ::class, 'sub_category_id', 'id')->withDefault();
    }

    public function variations()
    {
        return $this->hasMany(ProductVariant::class, 'product_id', 'id');
    }

    public function brand()
    {
        return $this->belongsTo(ProductBrand::class, 'brand_id', 'id')->withDefault();
    }

    public function unit()
    {
        return $this->belongsTo(ProductUnit::class, 'unit_id', 'id')->withDefault();
    }

    public function product_image()
    {
        return $this->hasMany(ProductImage::class, 'product_id', 'id');
    }

    public function course()
    {
        return $this->hasOne(Course::class, 'product_id', 'id')->withDefault();
    }

    public function thumbnail_media()
    {
        return $this->morphOne(UsedMedia::class, 'usable')->where('used_for', 'thumbnail');
    }

    public function soft_file_media()
    {
        return $this->morphOne(UsedMedia::class, 'usable')->where('used_for', 'soft_file');
    }

    public function pdf_media()
    {
        return $this->morphOne(UsedMedia::class, 'usable')->where('used_for', 'pdf');
    }


    public function getVariantDetailsAttribute()
    {
        $product = $this->load('variations');
        $attr_value = [];

        foreach ($product->variations as $variation) {
            $attributeTitle = $variation->attribute->title;
            $attributeValue = $variation->attributevalue->value;
            $attributeValueId = $variation->attributevalue->id;

            $existingAttribute = array_filter($attr_value, function ($object) use ($attributeTitle) {
                return $object->name === $attributeTitle;
            });

            if ($existingAttribute) {
                foreach ($attr_value as &$object) {
                    if ($object->name === $attributeTitle) {
                        if (!in_array($attributeValue, $object->value, true)) {
                            $object->value[] = $attributeValue;
                            $object->attr_val_id[] = (int) $attributeValueId;
                        }
                    }
                }
            } else {
                $newAttribute = new stdClass();
                $newAttribute->name = $attributeTitle;
                $newAttribute->attr_id = $variation->attribute->id;
                $newAttribute->value = [$attributeValue];
                $newAttribute->attr_val_id = [(int) $attributeValueId];
                $attr_value[] = $newAttribute;
            }
        }
        return $attr_value;
    }

    public function productSku()
    {
        return $this->hasMany(ProductSku::class,'product_id')->orderBy('price');

    }

    public function productSkuMinPrice()
    {
     return $this->productSku->first()->price ?? 0;
    }

}
