<?php

namespace Modules\Noticeboard\Http\Controllers;

use Illuminate\Routing\Controller;
use Modules\CourseSetting\Repositories\Interfaces\CourseRepositoryInterface;
use Modules\Noticeboard\Http\Requests\NoticeboardRequest;
use Modules\Noticeboard\Repositories\Interfaces\CourseNoticeboardRepositoryInterface;
use Modules\Noticeboard\Repositories\Interfaces\NoticeboardTypeRepositoryInterface;
use Modules\RolePermission\Repositories\RoleRepositoryInterface;

class CourseNoticeboardController extends Controller
{
    protected $courseNoticeboardRepository, $noticeboardTypeRepository, $courseRepository, $roleRepository;

    public function __construct(
        CourseNoticeboardRepositoryInterface $courseNoticeboardRepository,
        NoticeboardTypeRepositoryInterface   $noticeboardTypeRepository,
        CourseRepositoryInterface            $courseRepository,
        RoleRepositoryInterface              $roleRepository
    )
    {
        $this->courseNoticeboardRepository = $courseNoticeboardRepository;
        $this->noticeboardTypeRepository = $noticeboardTypeRepository;
        $this->courseRepository = $courseRepository;
        $this->roleRepository = $roleRepository;
    }

    public function index()
    {
        return view('noticeboard::notice.index', [
            'group' => 2,
            'notices' => $this->courseNoticeboardRepository->allCourse(['*'], ['user', 'noticeType', 'assign', 'assign.course']),
            'types' => $this->noticeboardTypeRepository->allActiveInArray('id', 'title'),
            'courses' => $this->courseRepository->allActiveCourseInArray('id', 'title'),
        ]);
    }

    public function store(NoticeboardRequest $request)
    {
        if (demoCheck()) {
            return redirect()->back();
        }
        $this->courseNoticeboardRepository->createCourseNotice($request->validated());
        return redirect()->back();
    }

    public function show(NoticeboardRequest $request)
    {
        return view('noticeboard::notice._edit_modal', [
            'noticeboard' => $this->courseNoticeboardRepository->findById($request->id, ['*'], ['assign']),
            'types' => $this->noticeboardTypeRepository->allActiveInArray('id', 'title'),
            'courses' => $this->courseRepository->allActiveInArray('id', 'title'),
            'roles' => $this->roleRepository->allActiveInArray(),
        ]);

    }

    public function update(NoticeboardRequest $request)
    {
        if (demoCheck()) {
            return redirect()->back();
        }
        $this->courseNoticeboardRepository->updateCourseNotice($request->validated());
        return redirect()->back();
    }

    public function delete(NoticeboardRequest $request)
    {
        if (demoCheck()) {
            return redirect()->back();
        }
        $this->courseNoticeboardRepository->deleteCourseNotice($request->validated());
        return redirect()->back();
    }

}
