<?php

namespace Modules\Noticeboard\Entities;

use App\User;
use Illuminate\Database\Eloquent\Model;

class Noticeboard extends Model
{
    protected $guarded = ['id'];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id')->withDefault();
    }

    public function noticeType()
    {
        return $this->belongsTo(NoticeType::class, 'type')->withDefault();
    }

    public function assign()
    {
        return $this->hasMany(NoticeboardAssign::class, 'noticeboard_id');
    }
}
