<?php

use Illuminate\Database\Migrations\Migration;

class AddPermissionForNoticeboard extends Migration
{
    public function up()
    {
        $routes = [
            ['name' => 'Noticeboard', 'route' => 'noticeboard', 'type' => 1, 'parent_route' => null, 'module' => 'Noticeboard'],

            ['name' => 'Notice Type', 'route' => 'noticeboard.type.index', 'type' => 2, 'parent_route' => 'noticeboard', 'module' => 'Noticeboard'],
            ['name' => 'Add', 'route' => 'noticeboard.type.store', 'type' => 3, 'parent_route' => 'noticeboard.type.index', 'module' => 'Noticeboard'],
            ['name' => 'Edit', 'route' => 'noticeboard.type.update', 'type' => 3, 'parent_route' => 'noticeboard.type.index', 'module' => 'Noticeboard'],
            ['name' => 'Delete', 'route' => 'noticeboard.type.delete', 'type' => 3, 'parent_route' => 'noticeboard.type.index', 'module' => 'Noticeboard'],
            ['name' => 'Change Status', 'route' => 'noticeboard.type.changeStatus', 'type' => 3, 'parent_route' => 'noticeboard.type.index', 'module' => 'Noticeboard'],

            ['name' => 'Course Notices', 'route' => 'noticeboard.course.index', 'type' => 2, 'parent_route' => 'noticeboard', 'module' => 'Noticeboard'],
            ['name' => 'Add', 'route' => 'noticeboard.course.store', 'type' => 3, 'parent_route' => 'noticeboard.course.index', 'module' => 'Noticeboard'],
            ['name' => 'Edit', 'route' => 'noticeboard.course.update', 'type' => 3, 'parent_route' => 'noticeboard.course.index', 'module' => 'Noticeboard'],
            ['name' => 'Delete', 'route' => 'noticeboard.course.delete', 'type' => 3, 'parent_route' => 'noticeboard.course.index', 'module' => 'Noticeboard'],
            ['name' => 'Change Status', 'route' => 'noticeboard.course.changeStatus', 'type' => 3, 'parent_route' => 'noticeboard.course.index', 'module' => 'Noticeboard'],

            ['name' => 'General Notices', 'route' => 'noticeboard.index', 'type' => 2, 'parent_route' => 'noticeboard', 'module' => 'Noticeboard'],
            ['name' => 'Add', 'route' => 'noticeboard.store', 'type' => 3, 'parent_route' => 'noticeboard.index', 'module' => 'Noticeboard'],
            ['name' => 'Edit', 'route' => 'noticeboard.update', 'type' => 3, 'parent_route' => 'noticeboard.index', 'module' => 'Noticeboard'],
            ['name' => 'Delete', 'route' => 'noticeboard.delete', 'type' => 3, 'parent_route' => 'noticeboard.index', 'module' => 'Noticeboard'],
            ['name' => 'Change Status', 'route' => 'noticeboard.changeStatus', 'type' => 3, 'parent_route' => 'noticeboard.index', 'module' => 'Noticeboard'],
        ];


        if (function_exists('permissionUpdateOrCreate')) {
            permissionUpdateOrCreate($routes);
        }
    }

    public function down()
    {
        //
    }
}
