<?php
namespace Modules\Appointment\Repositories\Eloquents;

use App\Repositories\Eloquents\BaseRepository;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Support\Facades\Session;
use Modules\Appointment\Entities\AppointmentSettings;
use Modules\Appointment\Repositories\Interfaces\SettingsRepositoryInterface;

class SettingsRepository extends BaseRepository implements SettingsRepositoryInterface
{
    public function __construct(
        AppointmentSettings $model
    ) {
        parent::__construct($model);
    }
    public function index():array
    {
        $exit = $this->model->first();
        if (!$exit) {
            $this->store();
        }
        if ($exit->access == 1 && auth()->user()->role_id !=1) {
            $data['no_permission'] = true;
            Toastr::error(trans('appointment.Access Denied'), trans('common.Error'));

            return redirect()->back()->send();
        }
        $data['setting'] = $this->model->first();
        if (!$data['setting']) {
            $setting = $exit->replicate();
            $setting->user_id = auth()->user()->id;
            $setting->save();
        }
        return $data;
    }
    public function update(int $modelId, array $payload): bool
    {
        $model = $this->findById($modelId);
        return $model->update($this->formatParams($payload, $modelId));
    }

    private function formatParams($payload, $modelId = null): array
    {
        if (gv($payload, 'type') == 'access') {
            $formatParams = [
                'access' => gv($payload, 'access')
            ];
        }

        if (gv($payload, 'type') == 'profile') {
            $formatParams = [
                'popular' => gv($payload, 'popular'),
                'trail_lesson' => gv($payload, 'trail_lesson'),
                'lesson_booked' => gv($payload, 'lesson_booked'),
                'review_option' => gv($payload, 'review_option'),
                'submit_review' => gv($payload, 'submit_review'),
                'number_of_student' => gv($payload, 'number_of_student'),
            ];
        }
        Session::put('trail_lesson', gv($payload, 'trail_lesson') ?? 0);
        return $formatParams;
    }
    private function store()
    {
        $setting = $this->model;
        $setting->access = 0;
        $setting->user_id = auth()->user()->id;
        $setting->save();
    }
}
