<?php

namespace Modules\Appointment\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Contracts\Support\Renderable;
use Modules\Appointment\Repositories\Interfaces\InstructorRepositoryInterface;
use Modules\Appointment\Repositories\Interfaces\AppointmentRepositoryInterface;

class InstructorController extends Controller
{
    public $appointmentRepository;
    public $instructorRepository;

    public function __construct(
        AppointmentRepositoryInterface $appointmentRepository,
        InstructorRepositoryInterface  $instructorRepository
    )
    {
        $this->instructorRepository = $instructorRepository;
        $this->appointmentRepository = $appointmentRepository;
    }

    public function index()
    {
        return view('appointment::index');
    }


    public function create()
    {
        $data = $this->appointmentRepository->requiredData();
        return view('appointment::instructor.create', $data);
    }



    public function show($id)
    {
        return view('appointment::show');
    }


    public function edit($id)
    {
        $data = $this->instructorRepository->editData($id);
        return view('appointment::instructor.edit', $data);
    }


    public function update(Request $request, $id)
    {
        $this->appointmentRepository->instructorStoreData($request->except('_token'), $id);
        $data = $this->appointmentRepository->instructorData();
        $data['type'] = $request->type;
        Toastr::success(trans('common.Operation successful'), trans('common.Success'));
        return redirect()->route('changePassword', ['type' => $request->type]);
    }

    public function education()
    {
        return view('appointment::instructor.inc.education');
    }

}
