@extends('backend.master')
@section('mainContent')
    {{generateBreadcrumb()}}
    <section class="mb-40 up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="white-box">
                <div class="row justify-content-center">
                    <div class="col-12">
                        <div class="box_header common_table_header">
                            <div class="main-title d-flex">
                                <h3 class="mb-0 mr-30" id="page_title">{{ __('whatsapp.agents') }}</h3>
                                <ul>
                                    <li><a href="{{ route('whatsapp-support.agents.create') }}"
                                           class="primary-btn radius_30px fix-gr-bg text-white"><i
                                                class="ti-plus"></i> {{ __('whatsapp.add_agent') }}</a>
                                    </li>
                                </ul>
                            </div>

                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <!-- table-responsive -->
                                <div class="table-responsive">
                                    <table class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <th scope="col">{{ __('whatsapp.id') }}</th>
                                            <th scope="col">{{ __('whatsapp.name') }}</th>
                                            <th scope="col">{{ __('whatsapp.designation') }}</th>
                                            <th scope="col">{{ __('whatsapp.number') }}</th>
                                            <th scope="col">{{ __('whatsapp.URL') }}</th>
                                            <th scope="col">{{ __('whatsapp.action') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @forelse($agents as $index => $agent)
                                            <tr>
                                                <th><a>{{ translatedNumber($index+1) }}</a></th>
                                                <td><a href="">{{ $agent->name }}</a></td>
                                                <td>{{ $agent->designation }}</td>
                                                <td>{{ translatedNumber($agent->number) }}</td>
                                                <td>{{ $agent->url }}</td>
                                                <td>
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu2" data-bs-toggle="dropdown"
                                                                aria-haspopup="true" aria-expanded="false">
                                                            {{__('common.Select')}}
                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu2">
                                                            <a class="dropdown-item"
                                                               href="{{ route('whatsapp-support.agents.show', $agent->id) }}"
                                                               type="button">{{__('common.Edit')}}</a>
                                                            <a href="#" data-bs-toggle="modal"
                                                               data-bs-target="#deleteAdmissionQueryModal{{$index}}"
                                                               class="dropdown-item"
                                                               type="button">{{__('common.Delete')}}</a>

                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                            <div class="modal fade admin-query"
                                                 id="deleteAdmissionQueryModal{{ $index }}">
                                                <div class="modal-dialog modal-dialog-centered">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title">{{__('common.Delete')}} {{__('common.File')}}</h4>
                                                            <button type="button" class="close text-success"
                                                                    data-bs-dismiss="modal">&times;
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <div class="text-center">
                                                                <h4>{{__('common.Are you sure')}}?</h4>
                                                            </div>
                                                            <div class="mt-40 d-flex justify-content-between">
                                                                <button type="button" class="primary-btn tr-bg"
                                                                        data-bs-dismiss="modal">{{__('common.Cancel')}}
                                                                </button>
                                                                <a href="{{ route('whatsapp-support.agents.delete', $agent->id) }}"
                                                                   class="primary-btn fix-gr-bg"
                                                                   type="submit">{{__('common.Delete')}}</a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        @empty
                                        @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </section>
@endsection
