<?php

namespace Modules\Survey\Http\Controllers;

use App\StudentGroup;
use Brian2694\Toastr\Facades\Toastr;
use DB;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\CourseSetting\Entities\Course;
use Modules\Survey\Entities\Survey;
use Modules\Survey\Entities\SurveyAnswerSubmit;
use Modules\Survey\Entities\SurveyQuestionBank;

class SurveyReportController extends Controller
{
    public function index()
    {
        return view('survey::index');
    }

    public function questionBasedGraph($survey_id)
    {
        $survey = Survey::findOrFail($survey_id);
        return view('survey::report.question_wise_graph', compact('survey'));
    }

    public function questionBasedGraphSearch(Request $request, $survey_id)
    {
        $rules = [
            'question_id' => 'required',
            'graph_type' => 'required',
        ];

        $request->validate($rules, validationMessage($rules));
        try {
            $survey = Survey::find($survey_id);
            $submitted_answers = SurveyAnswerSubmit::where('question_id', $request->question_id)->where('survey_id', $request->survey_id)->get();
            $selected_question = SurveyQuestionBank::where('id', $request->question_id)->first();
            $graph_type = $request->graph_type;
            $answer_set = '';

            if ($selected_question->type != 'textarea') {
                if ($request->graph_type == 'pie') {
                    $pie_set[] = [trans('survey.Answer'), trans('survey.User Count')];

                    if ($selected_question->type == 'linear_scale') {
                        $option = $selected_question->number_of_option;
                        for ($i = 1; $i <= $option; $i++) {
                            $pie_set[] = [(string)$i, $submitted_answers->where('answer', $i)->count()];
                        }
                    } else {
                        foreach ($selected_question->questionMu as $key => $attribute) {
                            $pie_set[] = [$attribute->title, $submitted_answers->where('answer', $attribute->id)->count()];
                        }
                    }

                    $answer_set = json_encode($pie_set);
                }
                if ($request->graph_type == 'bar') {
                    $bar_set[] = [trans('survey.Answer'), trans('survey.Percentage')];
                    if ($selected_question->type == 'linear_scale') {
                        $option = $selected_question->number_of_option;
                        for ($i = 1; $i <= $option; $i++) {
                            $total = $submitted_answers->where('answer', $i)->count() * 100;
                            if ($total != 0) {
                                $percentage = $total / $submitted_answers->count();
                            } else {
                                $percentage = 0;
                            }
                            $bar_set[] = [(string)$i, $percentage];
                        }
                    }else{
                        foreach ($selected_question->questionMu as $key => $attribute) {
                            $total = $submitted_answers->where('answer', $attribute->id)->count() * 100;
                            if ($total != 0) {
                                $percentage = $total / $submitted_answers->count();
                            } else {
                                $percentage = 0;
                            }
                            $bar_set[] = [$attribute->title, $percentage];
                        }
                    }

                    $answer_set = json_encode($bar_set);
                }
                if ($request->graph_type == 'line') {
                    $line_set[] = [trans('survey.Answer'), trans('survey.Opinions')];
                    if ($selected_question->type == 'linear_scale') {
                        $option = $selected_question->number_of_option;
                        for ($i = 1; $i <= $option; $i++) {
                            $line_set[] = [(string)$i, $submitted_answers->where('answer', $i)->count()];
                        }
                    } else {
                        foreach ($selected_question->questionMu as $key => $attribute) {
                            $line_set[] = [$attribute->title, $submitted_answers->where('answer', $attribute->id)->count()];
                        }
                    }
                    $answer_set = json_encode($line_set);
                }
            }
            // return  $answer_set;
            return view('survey::report.question_wise_graph', compact('survey', 'submitted_answers', 'selected_question', 'graph_type', 'answer_set'));
        } catch (\Throwable $th) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }

    }


    public function create()
    {
        return view('survey::create');
    }

    public function courseSurvey($course_id)
    {
        $course = Course::find($course_id);
        $surveys = $course->serveys;
        return view('survey::index', compact('surveys'));
    }

    public function groupSurvey($group_id)
    {
        $group = StudentGroup::find($group_id);
        $surveys = $group->serveys;
        return view('survey::index', compact('surveys'));
    }
}
