<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddNewSurveyTypeColumnInSurvey extends Migration
{
    public function up()
    {
        Schema::table('surveys', function ($table) {
            if (!Schema::hasColumn('surveys', 'category_id')) {
                $table->integer('category_id')->nullable();
            }
            if (!Schema::hasColumn('surveys', 'survey_type')) {
                $table->tinyInteger('survey_type')->default(1);
            }
            if (!Schema::hasColumn('surveys', 'audience')) {
                $table->tinyInteger('audience')->default(1);
            }
            if (!Schema::hasColumn('surveys', 'position_audience')) {
                $table->tinyInteger('position_audience')->default(1);
            }
            if (!Schema::hasColumn('surveys', 'deadline_date')) {
                $table->string('deadline_date')->nullable();
            }
            if (!Schema::hasColumn('surveys', 'deadline_time')) {
                $table->string('deadline_time')->nullable();
            }
        });
    }

    public function down()
    {
        //
    }
}
