@extends('backend.master')
@push('styles')
 @endpush
@php
    $table_name='faqs';
@endphp
@section('table')
    {{$table_name}}
@endsection

@section('mainContent')

    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="white-box">

                <div class="row justify-content-center">
                    <div class="col-12">
                        <div class="box_header common_table_header">
                            <div class="main-title d-md-flex">
                                <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px">{{__('subscription.FAQ List')}}</h3>

                                <ul class="d-flex">
                                    <li><a class="primary-btn radius_30px   fix-gr-bg" data-bs-toggle="modal"
                                           id="add_faq_btn"
                                           data-bs-target="#add_faq" href="#"><i
                                                class="ti-plus"></i>{{__('subscription.Add FAQ')}}</a></li>
                                </ul>

                            </div>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <!-- table-responsive -->
                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <th>#</th>
                                            <th scope="col">{{__('subscription.Question')}}</th>
                                            <th scope="col">{{__('subscription.Answer')}}</th>
                                            <th scope="col">{{__('common.Status')}}</th>
                                            <th scope="col">{{__('common.Action')}}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($faqs as $key => $faq)
                                            <tr data-item="{{$faq->id}}">
                                                <td>
                                                    <i class="ti-menu"></i>
                                                </td>
                                                <td>{{@$faq->question}}</td>
                                                <td>{!! @$faq->answer !!}</td>
                                                <td class="nowrap">
                                                    <label class="switch_toggle">
                                                        <input type="checkbox"
                                                               class="@if (permissionCheck('subscription.change_status'))  status_enable_disable @endif "
                                                               @if (@$faq->status == 1) checked
                                                               @endif value="{{@$faq->id }}">
                                                        <i class="slider round"></i>
                                                    </label>
                                                </td>

                                                <td>
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu2" data-bs-toggle="dropdown"
                                                                aria-haspopup="true"
                                                                aria-expanded="false">
                                                            {{__('common.Action')}}
                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu2">
                                                            @if (permissionCheck('subscription.edit'))
                                                                <button data-item="{{$faq}}"
                                                                        class="dropdown-item editfaq"
                                                                        type="button">{{__('common.Edit')}}</button>
                                                            @endif

                                                            @if (permissionCheck('subscription.delete'))
                                                                <button class="dropdown-item deletefaq"
                                                                        data-id="{{$faq->id}}"
                                                                        type="button">{{__('common.Delete')}}</button>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>

                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="modal fade admin-query" id="add_faq">
                        <div class="modal-dialog modal_1000px modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">{{__('subscription.Add FAQ')}}</h4>
                                    <button type="button" class="close " data-bs-dismiss="modal">
                                        <i class="ti-close "></i>
                                    </button>
                                </div>

                                <div class="modal-body">
                                    <form action="{{route('subscription.faq.store')}}" method="POST"
                                          enctype="multipart/form-data">
                                        @csrf
                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for="">{{__('subscription.Question')}} <strong
                                                            class="text-danger">*</strong></label>
                                                    <input class="primary_input_field" name="question" placeholder="-"
                                                           required
                                                           type="text" id="addQuestion"
                                                           value="{{ old('question') }}" {{$errors->first('question') ? 'autofocus' : ''}}>
                                                </div>
                                            </div>


                                        </div>
                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-35">
                                                    <label class="primary_input_label"
                                                           for="">{{__('subscription.Answer')}} <strong
                                                            class="text-danger">*</strong></label>
                                                    <textarea class="lms_summernote" name="answer" id="addAnswer"
                                                              cols="30"
                                                              rows="10">{{ old('answer') }}</textarea>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-lg-12 text-center pt_15">
                                            <div class="d-flex justify-content-center">
                                                <button class="primary-btn semi_large2  fix-gr-bg"
                                                        id="save_button_parent"
                                                        type="submit"><i
                                                        class="ti-check"></i> {{__('common.Save')}} {{__('subscription.FAQ')}}
                                                </button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="modal fade admin-query" id="editfaq">
                        <div class="modal-dialog modal_1000px modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">{{__('subscription.Update FAQ')}}</h4>
                                    <button type="button" class="close " data-bs-dismiss="modal">
                                        <i class="ti-close "></i>
                                    </button>
                                </div>

                                <div class="modal-body">
                                    <form action="{{route('subscription.faq.update')}}" method="POST"
                                          enctype="multipart/form-data">
                                        @csrf
                                        <input type="hidden" name="id" value="{{old('id')}}" id="faqId">
                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for="">{{__('subscription.Question')}} <strong
                                                            class="text-danger">*</strong></label>
                                                    <input class="primary_input_field" name="question" placeholder="-"
                                                           required
                                                           type="text" id="editQuestion"
                                                           value="{{ old('question') }}" {{$errors->first('question') ? 'autofocus' : ''}}>
                                                </div>
                                            </div>


                                        </div>
                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-35">
                                                    <label class="primary_input_label"
                                                           for="">{{__('subscription.Answer')}} <strong
                                                            class="text-danger">*</strong></label>
                                                    <textarea class="lms_summernote" name="answer" id="editAnswer"
                                                              cols="30"
                                                              required
                                                              rows="10">{{ old('answer') }}</textarea>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for="">{{__('subscription.Order')}} </label>
                                                    <input class="primary_input_field" name="order" placeholder="-"

                                                           type="text" id="editOrder"
                                                           value="{{ old('order') }}" {{$errors->first('order') ? 'autofocus' : ''}}>
                                                </div>
                                            </div>


                                        </div>
                                        <div class="col-lg-12 text-center pt_15">
                                            <div class="d-flex justify-content-center">
                                                <button class="primary-btn semi_large2  fix-gr-bg"
                                                        id="save_button_parent" type="submit"><i
                                                        class="ti-check"></i> {{__('subscription.Update FAQ')}}
                                                </button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal fade admin-query" id="deletefaq">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">{{__('common.Delete')}} {{__('subscription.FAQ')}} </h4>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"><i
                                            class="ti-close "></i></button>
                                </div>

                                <div class="modal-body">
                                    <form action="{{route('subscription.faq.destroy')}}" method="post">
                                        @csrf

                                        <div class="text-center">

                                            <h4>{{__('common.Are you sure to delete ?')}} </h4>
                                        </div>
                                        <input type="hidden" name="id" value="" id="faqDeleteId">
                                        <div class="mt-40 d-flex justify-content-between">
                                            <button type="button" class="primary-btn tr-bg"
                                                    data-bs-dismiss="modal">{{__('common.Cancel')}}</button>

                                            <button class="primary-btn fix-gr-bg"
                                                    type="submit">{{__('common.Delete')}}</button>

                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>

@endsection
@push('scripts')
    @include('subscription::faq.script')
@endpush

