<?php

namespace Modules\Store\Repositories;

use Modules\Store\Entities\DeliveryProcess;

class DeliveryProcessRepository
{
    public function getAll()
    {
        return DeliveryProcess::all();
    }

    public function save($data)
    {
        $deliveryProcess = new DeliveryProcess();
        $deliveryProcess->fill($data)->save();

    }

    public function update($data, $id)
    {
        $deliveryProcess = DeliveryProcess::findOrFail($id);
        $deliveryProcess->update([
            'name' => $data['name'],
            'description' => $data['description']
        ]);
    }

    public function delete($id)
    {
        $process = DeliveryProcess::find($id);
        if ($process) {
            $process->delete();
            return true;
        }
        return false;
    }

    public function getById($id){
        return DeliveryProcess::find($id);
    }
}
