<?php

namespace Modules\Store\Http\Controllers;

use Illuminate\Routing\Controller;
use Modules\RolePermission\Entities\Permission;
use Modules\SidebarManager\Entities\PermissionSection;

class StoreOrderResetController extends Controller
{

    public function changeOrder()
    {
        $section = PermissionSection::create([
            'name' => 'Store',
            'position' => PermissionSection::count() + 1,
            'ecommerce' => 1,
        ]);



        $menus = [


            [
                'name' => 'Product Manage',
                'route' => 'store.products',
                'parent_route' => null,
                'type' => 1,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
//            category
            [
                'name' => 'Categories',
                'route' => 'store.category.index',
                'parent_route' => 'store.products',
                'type' => 2,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ], [
                'name' => 'Add',
                'route' => 'store.category.store',
                'parent_route' => 'store.category.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ], [
                'name' => 'Edit',
                'route' => 'store.category.edit',
                'parent_route' => 'store.category.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Update',
                'route' => 'store.category.update',
                'parent_route' => 'store.category.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],

            [
                'name' => 'Delete',
                'route' => 'store.category.destroy',
                'parent_route' => 'store.category.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Status',
                'route' => 'store.category.status',
                'parent_route' => 'store.category.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
//brand
            [
                'name' => 'Brands',
                'route' => 'store.brand.index',
                'parent_route' => 'store.products',
                'type' => 2,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Add',
                'route' => 'store.brand.create',
                'parent_route' => 'store.brand.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Store',
                'route' => 'store.brand.store',
                'parent_route' => 'store.brand.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Edit',
                'route' => 'store.brand.edit',
                'parent_route' => 'store.brand.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Update',
                'route' => 'store.brand.update',
                'parent_route' => 'store.brand.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Delete',
                'route' => 'store.brand.destroy',
                'parent_route' => 'store.brand.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Status',
                'route' => 'store.brand.status',
                'parent_route' => 'store.brand.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],

//            attribute
            [
                'name' => 'Attributes',
                'route' => 'store.attribute.index',
                'parent_route' => 'store.products',
                'type' => 2,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Add',
                'route' => 'store.attribute.store',
                'parent_route' => 'store.attribute.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'View',
                'route' => 'store.attribute.view',
                'parent_route' => 'store.attribute.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Edit',
                'route' => 'store.attribute.edit',
                'parent_route' => 'store.attribute.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Update',
                'route' => 'store.attribute.update',
                'parent_route' => 'store.attribute.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Delete',
                'route' => 'store.attribute.destroy',
                'parent_route' => 'store.attribute.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Status',
                'route' => 'store.attribute.status',
                'parent_route' => 'store.attribute.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],

//            units
            [
                'name' => 'Units',
                'route' => 'store.unit.index',
                'parent_route' => 'store.products',
                'type' => 2,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Add',
                'route' => 'store.unit.store',
                'parent_route' => 'store.unit.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Edit',
                'route' => 'store.unit.edit',
                'parent_route' => 'store.unit.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Update',
                'route' => 'store.unit.update',
                'parent_route' => 'store.unit.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Delete',
                'route' => 'store.unit.destroy',
                'parent_route' => 'store.unit.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Status',
                'route' => 'store.unit.status',
                'parent_route' => 'store.unit.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
//Start Publication
            [
                'name' => 'Publications',
                'route' => 'store.publication.index',
                'parent_route' => 'store.products',
                'type' => 2,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Add',
                'route' => 'store.publication.store',
                'parent_route' => 'store.publication.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Edit',
                'route' => 'store.publication.edit',
                'parent_route' => 'store.publication.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Update',
                'route' => 'store.publication.update',
                'parent_route' => 'store.publication.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Delete',
                'route' => 'store.publication.destroy',
                'parent_route' => 'store.publication.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Status',
                'route' => 'store.publication.status',
                'parent_route' => 'store.publication.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Authors',
                'route' => 'store.author.index',
                'parent_route' => 'store.products',
                'type' => 2,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Add',
                'route' => 'store.author.store',
                'parent_route' => 'store.author.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Edit',
                'route' => 'store.author.edit',
                'parent_route' => 'store.author.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Update',
                'route' => 'store.author.update',
                'parent_route' => 'store.author.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Delete',
                'route' => 'store.author.destroy',
                'parent_route' => 'store.author.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Status',
                'route' => 'store.author.status',
                'parent_route' => 'store.author.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],




            [
                'name' => 'Add New Product',
                'route' => 'store.product.create',
                'parent_route' => 'store.products',
                'type' => 2,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],

            [
                'name' => 'Product Store',
                'route' => 'store.product.store',
                'parent_route' => 'store.product.create',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Products',
                'route' => 'store.product.index',
                'parent_route' => 'store.products',
                'type' => 2,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Edit',
                'route' => 'store.product.edit',
                'parent_route' => 'store.product.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Update',
                'route' => 'store.product.update',
                'parent_route' => 'store.product.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Delete',
                'route' => 'store.product.destroy',
                'parent_route' => 'store.product.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],

            [
                'name' => 'Status',
                'route' => 'store.product.status',
                'parent_route' => 'store.product.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],

            [
                'name' => 'Bulk Product Upload',
                'route' => 'bulk_product_upload_page',
                'parent_route' => 'store.products',
                'type' => 2,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],

            [
                'name' => 'Bulk Product Store',
                'route' => 'product.bulk_product_store',
                'parent_route' => 'bulk_product_upload_page',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Product Excel Download',
                'route' => 'product.excel.download',
                'parent_route' => 'bulk_product_upload_page',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],

            [
                'name' => 'Status',
                'route' => 'store.review.status',
                'parent_route' => 'store.product.reviews',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],


            [
                'name' => 'Product Details',
                'route' => 'store.product.details',
                'parent_route' => 'store.product.index',
                'type' => 3,
                'backend' => 0,
                'module' => 'Store',
                'section_id' => $section->id,
            ],

            [
                'name' => 'All Products',
                'route' => 'store.product.all',
                'parent_route' => 'store.product.index',
                'type' => 3,
                'backend' => 0,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Give Review',
                'route' => 'store.product.giveReview',
                'parent_route' => 'store.product.index',
                'type' => 3,
                'backend' => 0,
                'module' => 'Store',
                'section_id' => $section->id,
            ],


            [
                'name' => 'Order Manage',
                'route' => 'store.orders',
                'parent_route' => null,
                'type' => 1,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],


            [
                'name' => 'Orders',
                'route' => 'store.orders.index',
                'parent_route' => 'store.orders',
                'type' => 2,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Invoice',
                'route' => 'store.order.invoice',
                'parent_route' => 'store.orders.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],

            [
                'name' => 'Track order',
                'route' => 'store.trackorder',
                'parent_route' => 'store.orders.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],


            [
                'name' => 'Delivery Process',
                'route' => 'store.delivery.index',
                'parent_route' => 'store.orders',
                'type' => 2,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],

            [
                'name' => 'Add',
                'route' => 'store.delivery.store',
                'parent_route' => 'store.delivery.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ], [
                'name' => 'Edit',
                'route' => 'store.delivery.edit',
                'parent_route' => 'store.delivery.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Update',
                'route' => 'store.delivery.update',
                'parent_route' => 'store.delivery.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Delete',
                'route' => 'store.delivery.destroy',
                'parent_route' => 'store.delivery.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Status',
                'route' => 'store.delivery.status',
                'parent_route' => 'store.delivery.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],


            [
                'name' => 'Cancel Reason',
                'route' => 'store.cancelreason.index',
                'parent_route' => 'store.orders',
                'type' => 2,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],


            [
                'name' => 'Add',
                'route' => 'store.cancelreason.store',
                'parent_route' => 'store.cancelreason.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ], [
                'name' => 'Edit',
                'route' => 'store.cancelreason.edit',
                'parent_route' => 'store.cancelreason.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Update',
                'route' => 'store.cancelreason.update',
                'parent_route' => 'store.cancelreason.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Delete',
                'route' => 'store.cancelreason.destroy',
                'parent_route' => 'store.cancelreason.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Status',
                'route' => 'store.cancelreason.status',
                'parent_route' => 'store.cancelreason.index',
                'type' => 3,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],


            [
                'name' => 'Track Order Setting',
                'route' => 'store.trackorder.settings',
                'parent_route' => 'store.orders',
                'type' => 2,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],


            [
                'name' => 'Refund Manage',
                'route' => 'store.refund',
                'parent_route' => null,
                'type' => 1,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],

            [
                'name' => 'Pending Refund Request',
                'route' => 'store.refundpending.index',
                'parent_route' => 'store.refund',
                'type' => 2,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Confirmed Refund Request',
                'route' => 'store.refundconfirmed.index',
                'parent_route' => 'store.refund',
                'type' => 2,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Refund Reasons',
                'route' => 'store.refundreason.index',
                'parent_route' => 'store.refund',
                'type' => 2,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Refund Process',
                'route' => 'store.refundprocess.index',
                'parent_route' => 'store.refund',
                'type' => 2,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Refund Setting',
                'route' => 'store.refundsetting.index',
                'parent_route' => 'store.refund',
                'type' => 2,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],


            [
                'name' => 'Shipping',
                'route' => 'store.shipping',
                'parent_route' => null,
                'type' => 1,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Carriers',
                'route' => 'store.carrier.index',
                'parent_route' => 'store.shipping',
                'type' => 2,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],

            [
                'name' => 'Shipping Rates',
                'route' => 'store.shiprate.index',
                'parent_route' => 'store.shipping',
                'type' => 2,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],

            [
                'name' => 'Pickup Location',
                'route' => 'store.pickuplocation.index',
                'parent_route' => 'store.shipping',
                'type' => 2,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'Shipping Order',
                'route' => 'store.shiporder.index',
                'parent_route' => 'store.shipping',
                'type' => 2,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],

            [
                'name' => 'Shipping Setting',
                'route' => 'store.shipsetting.index',
                'parent_route' => 'store.shipping',
                'type' => 2,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],

            [
                'name' => 'My Order',
                'route' => 'store.my_order.index',
                'parent_route' => 'store.orders',
                'type' => 2,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
            [
                'name' => 'My Refund Requests',
                'route' => 'store.my_refund_requests.index',
                'parent_route' => 'store.refund',
                'type' => 2,
                'backend' => 1,
                'module' => 'Store',
                'section_id' => $section->id,
            ], [
                'name' => 'Store Refund & Dispute',
                'route' => 'myRefundDispute',
                'parent_route' => null,
                'type' => 1,
                'backend' => 0,
                'module' => 'Store',
                'section_id' => $section->id,
            ],
        ];


        permissionUpdateOrCreate($menus);


        $storeMenus = [
            'store.products',
            'store.orders',
            'store.shipping',
            'store.refund',
        ];
        $i = 1;
        foreach ($storeMenus as $k => $menu) {
            $item = Permission::where('route', $menu)->first();
            if ($item) {
                $item->position = $i++;
                $item->section_id = $section->id;
                $item->save();
            }

        }
    }
}
