<?php

namespace Modules\Store\Entities;

use App\User;
use Illuminate\Database\Eloquent\Model;
use Modules\Setting\Entities\UsedMedia;
use App\Traits\HasTranslations;

class ProductAuthor extends Model
{
    use HasTranslations;

    public $translatable = ['title', 'description'];
    protected $guarded = ['id'];

    public function user()
    {
        return $this->belongsTo(User::class)->withDefault();
    }

    public function image_media()
    {
        return $this->morphOne(UsedMedia::class, 'usable')->where('used_for', 'image');
    }

    public function publication()
    {
    return $this->belongsTo(ProductPublication::class,'publication_id')->withDefault();
    }
}
