<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddIsFreeColumnINProductTable extends Migration
{

    public function up()
    {
        Schema::table('products', function (Blueprint $table) {
            if (!Schema::hasColumn('products', 'has_variant')) {
                $table->boolean('has_variant')->default(0);
            }
            if (!Schema::hasColumn('products', 'is_free')) {
                $table->boolean('is_free')->default(0);
            }
            if (!Schema::hasColumn('products', 'unit_id')) {
                $table->unsignedBigInteger('unit_id')->nullable();
            }
        });

        Schema::table('product_variants', function (Blueprint $table) {
            if (!Schema::hasColumn('product_variants', 'product_sku_id')) {
                $table->unsignedBigInteger("product_sku_id")->nullable();
            }
        });

    }


    public function down()
    {
    }
}
