<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInstallmentPurchaseRequestsTable extends Migration
{
    public function up()
    {
        Schema::create('installment_purchase_requests', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id');
            $table->integer('plan_id');
            $table->integer('topic_id')->comment('course_id,quiz_id,live_class_id');
            $table->string('tracking')->nullable();
            $table->longText('cart_data')->nullable();
            $table->integer('total_installment');
            $table->integer('paid_installment');
            $table->integer('remaining_installment');
            $table->double('paid_amount');
            $table->longText('checkout_data')->nullable();
            $table->double('remaining_amount');
            $table->double('total_amount');
            $table->date('purchase_date')->nullable();
            $table->date('next_payment_date')->nullable();
            $table->string('payment_status')->default(0)->comment('0=pending,1=approved,3=rejected,4=incomplete');

            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('installment_purchase_requests');
    }
}
