<?php

namespace Modules\Gift\Entities;

use App\User;
use Illuminate\Database\Eloquent\Model;

class GiftRecord extends Model
{
    protected $fillable = ['gift_status', 'checkout_data'];

    public function course()
    {
        return $this->belongsTo('Modules\CourseSetting\Entities\Course', 'course_id', 'id');
    }

    public function sender()
    {
        return $this->belongsTo(User::class, 'user_id', 'id')->withDefault();
    }

    public function receiver()
    {
        return $this->belongsTo(User::class, 'gift_receiver_id', 'id')->withDefault();
    }

    protected $casts = [
        'checkout_data' => 'array',
    ];

    public function getStatusAttribute()
    {
        if ($this->gift_status == 1) {
            return 'Added to Cart';
        } elseif ($this->gift_status == 2) {
            return 'Purchased';
        } elseif ($this->gift_status == 3) {
            return 'Gifted';
        } elseif ($this->gift_status == 4) {
            return 'Enrolled';
        } elseif ($this->gift_status == 5) {
            return 'Expired';
        } else {
            return 'Unknown';
        }
    }
}
