<div class="modal fade admin-query admin_view_modal" id="viewAttachment{{$assign->id}}">
    <div class="modal-dialog modal_1000px modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">{{__('common.View')}} {{__('assignment.Attachment')}}</h4>
                <button type="button" class="close " data-bs-dismiss="modal">
                    <i class="ti-close "></i>
                </button>
            </div>
            <div class="modal-body">
                {!! @$submit_info->answer !!}
                <hr>
                @php
                    $std_file =$submit_info->file;
                    $ext =strtolower(str_replace('"]','',pathinfo($std_file, PATHINFO_EXTENSION)));
                    $attached_file=str_replace('"]','',$std_file);
                    $attached_file=str_replace('["','',$attached_file);
                    $preview_files=['jpg','jpeg','png','heic','mp4','mov','mp3','mp4','pdf'];
                @endphp
                @if ($ext=='jpg' || $ext=='jpeg' || $ext=='png' || $ext=='heic')
                    <img class="img-responsive mt-20" style="width: 100%; height:auto" src="{{asset($attached_file)}}">
                @elseif($ext=='mp4' || $ext=='mov')
                    <video class="mt-20 video_play" width="100%" controls>
                        <source src="{{asset($attached_file)}}" type="video/mp4">
                        <source src="mov_bbb.ogg" type="video/ogg">
                        Your browser does not support HTML video.
                    </video>
                @elseif($ext=='mp3')
                    <audio class="mt-20 audio_play" controls style="width: 100%">
                        <source src="{{asset($attached_file)}}" type="audio/ogg">
                        <source src="horse.mp3" type="audio/mpeg">
                        Your browser does not support the audio element.
                    </audio>
                @elseif($ext=='pdf')
                    <object data='{{asset($attached_file)}}' type="application/pdf" width="100%" height="800">
                        <iframe src='{{asset($attached_file)}}' width="100%" height="800">
                            <p>This browser does not support PDF!</p>
                        </iframe>
                    </object>
                @endif
                @if (!in_array($ext,$preview_files))
                    <div class="alert alert-warning">
                        {{$ext}} File Not Previewable</a>.
                    </div>
                @endif
                <div class="row mt-40 d-flex justify-content-between">
                    @php
                        $set_filename=time().'_'.$std_file;
                    @endphp
                    @if (file_exists($attached_file))
                        <div class="col-lg-4">
                            <a class="primary-btn radius_30px   fix-gr-bg" download="{{$set_filename}}"
                               href="{{asset($attached_file)}}"> <span
                                    class="pl ti-download"> {{__('common.Download')}}</span></a>
                        </div>
                    @endif

                    <div class="col-lg-8">

                        <form action="{{route('saveAssignmentMarks')}}" method="post">
                            @csrf
                            <input type="hidden" name="assign_id" value="{{@$assign->id}}">
                            <input type="hidden" name="submit_info" value="{{@$submit_info->id}}">
                            <div class="d-flex gap-3 align-items-center">
                                <div class="col-lg-6">
                                    <div class="primary_input">
                                        <label class="primary_input_label"
                                               for="marks">{{ __('assignment.Marks') }} <strong
                                                class="text-danger">*</strong></label>
                                        <input name="marks" id="marks"
                                               class="primary_input_field name {{ @$errors->has('marks') ? ' is-invalid' : '' }}"
                                               placeholder="{{ __('assignment.Marks') }}"
                                               type="text" required
                                               value="{{isset($assign)?$assign->obtain_marks:old('marks')}}" {{$errors->has('marks') ? 'autofocus' : ''}}>
                                        @if ($errors->has('marks'))
                                            <span class="invalid-feedback d-block mb-10" role="alert">
                                                <strong>{{ @$errors->first('marks') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-lg-2 mt-30">
                                    <button class="primary-btn fix-gr-bg submit"
                                            type="submit">{{__('common.Save')}}</button>

                                </div>

                            </div>
                        </form>
                    </div>

                </div>

                <hr>
            </div>

        </div>
    </div>
</div>

@push('script')
    <script type="text/javascript">
        (function ($) {
            "use strict";
            jQuery('.admin_view_modal').on('hidden.bs.modal', function (e) {
                $('.video_play').get(0).play();
                $('.video_play').trigger('pause');

                $('.audio_play').get(0).play();
                $('.audio_play').trigger('pause');
            });
        })(jQuery);

    </script>
@endpush
