<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\RolePermission\Entities\Permission;

class AddPermissionForAssignment extends Migration
{
    public function up()
    {
        $routes = [
            ['name' => 'Assignment', 'route' => 'assignment', 'type' => 1, 'parent_route' => null, 'module' => 'Assignment'],
            ['name' => 'List', 'route' => 'assignment_list', 'type' => 2, 'parent_route' => 'assignment', 'module' => 'Assignment'],
            ['name' => 'Add', 'route' => 'assignment_add', 'type' => 3, 'parent_route' => 'assignment_list', 'module' => 'Assignment'],
            ['name' => 'Edit', 'route' => 'assignment_edit', 'type' => 3, 'parent_route' => 'assignment_list', 'module' => 'Assignment'],
            ['name' => 'Delete', 'route' => 'assignment_delete', 'type' => 3, 'parent_route' => 'assignment_list', 'module' => 'Assignment'],
            ['name' => 'Assign', 'route' => 'assignment_assign', 'type' => 3, 'parent_route' => 'assignment_list', 'module' => 'Assignment'],
            ['name' => 'Marking', 'route' => 'assignment_marking', 'type' => 3, 'parent_route' => 'assignment_list', 'module' => 'Assignment'],

            ['name' => 'Course Assignment', 'route' => 'courseAssignmentList', 'type' => 2, 'parent_route' => 'courses', 'module' => 'Assignment'],


            ['name' => 'My Assignment', 'route' => 'myAssignment', 'type' => 1, 'parent_route' => null, 'backend' => 0, 'module' => 'Assignment'],
        ];
        if (function_exists('permissionUpdateOrCreate')) {
            permissionUpdateOrCreate($routes);
        }
    }

    public function down()
    {
        //
    }
}
