@extends('appointment::layouts.master')
@section('mainContent')
    <section class="sms-breadcrumb mb-10 white-box">
        <div class="container-fluid">
            <div class="row justify-content-between">
                <h1>{{ __('appointment.Tutor Finder') }}</h1>
                <div class="bc-pages">
                    <a href="{{ route('dashboard') }}">{{ __('common.Dashboard') }}</a>
                    <a href="#">{{ __('appointment.appointment') }}</a>
                    <a class="active" href="#">{{ __('appointment.Tutor Finder') }}</a>
                </div>
            </div>
        </div>
    </section>
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="col-12">
                    <div class="box_header common_table_header">
                        <div class="main-title d-md-flex">
                            <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px">{{__('appointment.Pages')}}</h3>
                            <ul class="d-flex">

                            </ul>
                        </div>
                    </div>
                </div>

                <div class="col-lg-12">
                    <div class="QA_section QA_section_heading_custom check_box_table">
                        <div class="QA_table ">
                            <div class="" id="lms_data_table">
                                @include('appointment::page.list')
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div id="append_html"></div>

        @include('appointment::page.create')
        <input type="hidden" value="{{route('page_builder.pages.destroy')}}" id="delete_url">
        <input type="hidden" value="{{route('page_builder.pages.store')}}" id="store_url">
        <input type="hidden" value="{{route('page_builder.pages.edit',':id')}}" id="edit_url">
        <input type="hidden" value="{{route('page_builder.pages.update',':id')}}" id="update_url">
        <input type="hidden" value="{{route('page_builder.pages.status')}}" id="status_change_url">
    </section>
@endsection
@push('scripts')
    <script src="{{asset('Modules/Appointment/Resources/assets/js/datatable_active.js')}}"></script>
    <script src="{{asset('Modules/Appointment/Resources/assets/js/pages.js')}}"></script>
@endpush
