<?php
namespace Modules\Appointment\Repositories\Eloquents;

use App\Repositories\Eloquents\BaseRepository;
use Illuminate\Database\Eloquent\Model;
use Modules\Appointment\Entities\AppointmentFrontendPage;
use Modules\Appointment\Repositories\Interfaces\PageBuilderRepositoryInterface;

class PageBuilderRepository extends BaseRepository implements PageBuilderRepositoryInterface
{
    public function __construct(
        AppointmentFrontendPage $model
    ) {
        parent::__construct($model);
    }
    public function index(): array
    {
        $data['pages'] = $this->model->where('type', 'appointment_page')
        ->where('lms_id', auth()->user()->lms_id)->get();
        return $data;
    }
    public function tutorFinder(): array
    {
        $data['pages'] = $this->model->where('type', 'tutor_page')->where('lms_id', auth()->user()->lms_id)->get();
        return $data;
    }
    public function create(array $playLoad): ?Model
    {
        $model = $this->create($this->formatParams($playLoad));
        return $model;
    }
    public function update(int $modelId, array $playLoad): bool
    {
        $model = $this->findById($modelId);
        return $model->update($this->formatParams($playLoad, $modelId));
    }
    public function getEditPreRequisite($modelId): array
    {
        $data['editPage'] = $this->findById($modelId);
        return $data;
    }
    private function formatParams($playLoad, $modelId = null)
    {
        $formatParams = [
            'title' => gv($playLoad, 'title'),
        ];
        return $formatParams;
    }
    public function design($id): array
    {
        $data = [];
        $design = $this->findById($id);
        $data['design'] = $design;
        $data['row'] = $design;
        return $data;
    }
    public function designUpdatePage($id, $payload)
    {
        $this->model->where('id', $id)->update([
            'description' => $payload['body'],
        ]);
        return true;
    }
}
