<?php
namespace Modules\Appointment\Repositories\Eloquents;

use App\User;
use Modules\Appointment\Entities\Booking;
use Modules\Appointment\Entities\Wishlist;
use App\Repositories\Eloquents\BaseRepository;
use Modules\Appointment\Repositories\Interfaces\ScheduleRepositoryInterface;
use Modules\Appointment\Repositories\Interfaces\MyAppointmentRepositoryInterface;

class MyAppointmentRepository extends BaseRepository implements MyAppointmentRepositoryInterface
{
    public $user;
    public $wishlist;
    public $scheduleRepository;
    public function __construct(
        User $user,
        Booking $model,
        Wishlist $wishlist,
        ScheduleRepositoryInterface $scheduleRepository
    ) {
        parent::__construct($model);
        $this->user = $user;
        $this->wishlist = $wishlist;
        $this->scheduleRepository = $scheduleRepository;
    }
    public function index(): array
    {
        $data = [];
        $data['booking_list'] = $this->model->where('user_id', auth()->user()->id)->groupBy('schedule_id')->get();

        return $data;
    }
    public function myAppointment(): array
    {
        $data = [];
        return $data;
    }
    public function storeWishList($slug): bool
    {
        $instructor_id = $this->user->where('slug', $slug)->value('id');
        if (auth()->check()) {
            $this->wishlist->updateOrCreate([
                'instructor_id' => $instructor_id,
                'user_id' => auth()->user()->id,
            ]);
        }
        return true;
    }
    public function wishlist(): array
    {
        $data['lists'] = $this->wishlist->where('user_id', auth()->user()->id)->get();
        return $data;
    }
}
