        <?php

        use App\User;
        use Illuminate\Support\Str;
        use Illuminate\Support\Facades\DB;
        use Illuminate\Support\Facades\Schema;
        use Illuminate\Database\Schema\Blueprint;
        use Illuminate\Database\Migrations\Migration;

        class AddColumnToUser extends Migration
        {
            public function up()
            {

                Schema::table('users', function (Blueprint $table) {

                    if (!Schema::hasColumn('users', 'types')) {
                        $table->string('types')->nullable();
                    }
                    if (!Schema::hasColumn('users', 'slug')) {
                        $table->text('slug')->nullable();
                    }
                    if (!Schema::hasColumn('users', 'is_available')) {
                        $table->tinyInteger('is_available')->nullable()->default(0);
                    }
                    if (!Schema::hasColumn('users', 'available_msg')) {
                        $table->string('available_msg')->nullable();
                    }
                    if (!Schema::hasColumn('users', 'hour_rate')) {
                        $table->double('hour_rate')->nullable();
                    }
                    if (!Schema::hasColumn('users', 'age')) {
                        $table->integer('age')->nullable();
                    }
                    if (!Schema::hasColumn('users', 'short_video_link')) {
                        $table->text('short_video_link')->nullable();
                    }
                    if (!Schema::hasColumn('users', 'appointment_special_commission')) {
                        $table->double('appointment_special_commission')->nullable();
                    }

                });
                $sameNameUsers = DB::table('users')
                    ->select('id','name', DB::raw('COUNT(*) as `count`'))
                    ->groupBy('name')
                    ->havingRaw('COUNT(*) > 1')
                    ->get();
                $users = User::where('role_id', 2)->whereNotIn('id', $sameNameUsers->pluck('id')->toArray())
                    ->whereNull('slug')->get();


                foreach ($users as $user) {
                    User::where('id', $user->id)->update([
                        'slug' => Str::slug($user->name),
                    ]);
                }
                foreach ($sameNameUsers as $duplicate) {
                    User::where('id', $duplicate->id)->update([
                        'slug' => Str::slug($duplicate->name) . '-' . $duplicate->id,
                    ]);
                }


            }


            public function down()
            {
            }
        }
