<?php

namespace Modules\WhatsappSupport\Http\Controllers;

use App\Traits\UploadMedia;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\WhatsappSupport\Entities\Settings;

class SettingsController extends Controller
{
    use UploadMedia;

    public function index()
    {
        $settings = Settings::first();
        return view('whatsappsupport::settings.index', compact('settings'));
    }


    public function update(Request $request)
    {
         if (demoCheck()) {
            return redirect()->back();
        }
        $setting = Settings::first();
        $setting->update($request->except('_token', 'bubble_pic','whatsapp_logo'));

        $this->removeLink($setting->id, get_class($setting));

        $setting->bubble_logo = null;
        $setting->whatsapp_logo = null;

        if ($request->bubble_pic) {
            $setting->bubble_logo = $this->generateLink($request->bubble_pic, $setting->id, get_class($setting), 'bubble_logo');
        }

        if ($request->whatsapp_logo) {
            $setting->whatsapp_logo = $this->generateLink($request->whatsapp_logo, $setting->id, get_class($setting), 'whatsapp_logo');
        }
        $setting->save();


        Toastr::success(trans('common.Operation successful'), trans('common.Success'));
        return redirect()->back();
    }


}
