<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSubscriptionCheckoutsTable extends Migration
{

    public function up()
    {
        Schema::create('subscription_checkouts', function (Blueprint $table) {
            $table->id();
            $table->integer('billing_detail_id');
            $table->string('tracking')->nullable();
            $table->integer('user_id')->nullable();
            $table->integer('plan_id')->nullable();
            $table->integer('price')->default(0);
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->integer('days')->default(0);
            $table->string('payment_method')->nullable();
            $table->longText('response')->nullable();
            $table->tinyInteger('status')->default(0);
            $table->integer('lms_id')->default(1);
            $table->string('tax')->nullable();
            $table->timestamps();
        });
    }


    public function down()
    {
        Schema::dropIfExists('subscription_checkouts');
    }
}
