@extends('backend.master')

@section('mainContent')
    <link rel="stylesheet" href="{{ asset('Modules/Store/Resources/assets/css/sale_details.css') }}">
    <div id="add_product">
        <section class="admin-visitor-area up_st_admin_visitor">
            <div class="container-fluid p-0">
                <div class="row justify-content-center">
                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="box_header common_table_header">
                            <div class="main-title d-flex">
                                <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px">{{ $order->order_number }} </h3>
                                <ul class="d-flex float-end">
                                    <li><a href="{{ route('order_manage.print_my_order_details', $order->id) }}"
                                           target="_blank"
                                           class="primary-btn fix-gr-bg radius_30px  ">{{ __('common.Print') }}</a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-8 student-details">
                        <div class=" white-box box_shadow_white" id="printableArea">
                            <div class="row pb-30 border-bottom">
                                <div class="col-md-6 col-lg-6">
                                    <div class="logo_div">
                                        <img src="{{ getCourseImage(Settings('logo')) }}" alt="">
                                    </div>
                                </div>
                                <div class="col-md-6 col-lg-6 text-end">
                                    <h4>{{ $order->order_number }}</h4>
                                </div>
                            </div>
                            <div class="row mt-30">

                                <div class="col-md-6 col-lg-6">
                                    <table class="table-borderless clone_line_table">
                                        <tr>
                                            <td><strong>{{ __('product.Billing Info') }}</strong></td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('common.Name') }}</td>
                                            <td>: {{ @$order->bill->first_name }} {{ @$order->bill->last_name }} </td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('common.Phone') }}</td>
                                            <td>: {{ @$order->bill->phone }}</td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('common.Address') }}</td>
                                            <td>: {{ @$order->bill->address1 }}</td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('common.Address') }} 2</td>
                                            <td>: {{ @$order->bill->address2 }}</td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('common.Country') }}</td>
                                            <td>: {{ @$order->bill->countryDetails->name }} </td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('common.City') }}</td>
                                            <td>: {{ @$order->bill->cityDetails->name }} </td>
                                        </tr>
                                    </table>
                                </div>

                                <div class="col-md-6 col-lg-6">

                                    <table class="table-borderless clone_line_table">
                                        <tr>
                                            <td>
                                                <strong>{{ __('product.Shipping Info') }} @if ($order->delivery_type == 'pickup_location')
                                                        (Collect from Pickup location)
                                                    @endif
                                                </strong></td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('common.Name') }}</td>
                                            <td>: {{ @$order->bill->first_name }} {{ @$order->bill->last_name }} </td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('common.Phone') }}</td>
                                            <td>: {{ @$order->bill->phone }}</td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('common.Address') }}</td>
                                            <td>: {{ @$order->bill->address1 }}</td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('common.Address') }} 2</td>
                                            <td>: {{ @$order->bill->address2 }}</td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('common.Country') }}</td>
                                            <td>: {{ @$order->bill->countryDetails->name }} </td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('common.City') }}</td>
                                            <td>: {{ @$order->bill->cityDetails->name }} </td>
                                        </tr>
                                    </table>

                                </div>
                            </div>
                            <div class="row mt-30">
                                @php
                                    $order_packages = Modules\Store\Entities\OrderPackageDetail::where('seller_id', auth()->user()->id)->where('package_code', $package->package_code)->first();
                                @endphp
                                <div class="col-md-6 col-lg-6">
                                    <table class="table-borderless clone_line_table">
                                        <tr>
                                            <td><strong>{{ __('product.Payment Info') }}</strong></td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('product.Payment Method') }}</td>
                                            <td>: {{ $order->payment_method }}</td>
                                        </tr>

                                        <tr>
                                            <td>{{ __('product.Tracking Id') }}</td>
                                            <td>: {{ @$order->tracking }}</td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('common.Date') }}</td>
                                            <td>:
                                                {{ showDate($order->updated_at) }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('product.Payment Status') }}</td>
                                            <td>:
                                                @if ($order->is_paid == 1)
                                                    <span>{{ __('common.Paid') }}</span>
                                                @else
                                                    <span>{{ __('common.Pending') }}</span>
                                                @endif
                                            </td>
                                        </tr>
                                    </table>
                                </div>

                            </div>
                            <div class="row mt-30">
                                @php
                                    $p_total = 0;
                                    $p_qty = 0;
                                @endphp


                                <div class="col-12 mt-30">

                                    @if ($order_packages->is_cancelled == 1)
                                        <div class="primary_input mb-25">
                                            <label class="primary_input_label red" for="">
                                                {{__('product.order_cancelled')}} - ({{ $order_packages->package_code }}
                                                )
                                            </label>
                                        </div>

                                        <div class="primary_input mb-25">
                                            <label class="primary_input_label sub-title" for="">
                                                {{ @$order_packages->cancel_reason->name }}
                                            </label>
                                        </div>
                                    @endif

                                    <div class="box_header common_table_header">
                                        <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px">{{__('product.package')}}:
                                            {{ $order_packages->package_code }} @if ($order_packages->delivery_process)
                                                <small>({{ @$order_packages->delivery_process->name }})</small>
                                            @endif
                                        </h3>
                                        <ul class="d-flex float-end">
                                            <li><strong>{{ __('product.Shipping Method') }} :
                                                    {{ $order_packages->shipping->method_name }} </strong></li>
                                        </ul>
                                    </div>

                                    <div class="QA_section QA_section_heading_custom check_box_table">
                                        <div class="QA_table ">
                                            <div class="table-responsive">
                                                <table class="table">
                                                    <tr>
                                                        <th scope="col" style="text-align: left">
                                                            <span class="ps-3">
                                                                {{ __('common.SL') }}
                                                            </span>
                                                        </th>
                                                        <th colspan="2" scope="col" style="text-align: left"
                                                            class="black_color">{{ __('common.Image') }}</th>

                                                        <th colspan="2" scope="col" style="text-align: left"
                                                            class="black_color">{{ __('courses.Course') }} /
                                                            {{ __('student.Product') }} {{ __('common.Name') }}</th>

                                                        <th scope="col" class="black_color">{{ __('product.Type') }}
                                                        </th>
                                                        <th scope="col" class="black_color">{{ __('student.Quantity') }}
                                                        </th>


                                                        <th scope="col" class="black_color">{{ __('student.Price') }}
                                                        </th>
                                                        <th colspan="2" scope="col" style="text-align: left"
                                                            class="black_color">{{ __('student.Total') }}</th>
                                                    </tr>

                                                    @php
                                                        $total = 0;
                                                        $language_code = auth()->user()->language_code ?? 'en';
                                                        $sl = 1;
                                                        $qty = 0;
                                                        $shipping_cost = 0;
                                                        $all_product = Modules\Store\Entities\OrderPackageDetail::where(['order_id' => $order_packages->order_id , 'seller_id' => $order_packages->seller_id])->get();
                                                    @endphp
                                                     @foreach ($all_product as $key => $item)
                                                        @php
                                                            if (!$item->course){
                                                                continue;
                                                            }
                                                        @endphp
                                                        <tr>
                                                            <td class="black_color">
                                                                <span class="ps-3">
                                                                    {{ $sl++ }}
                                                                </span>
                                                            </td>
                                                             <td colspan="2" style="text-align: left">
                                                                <div class="product_img_div">
                                                                    <img
                                                                        src="{{ getCourseImage($item->course->thumbnail) }}"
                                                                        alt="">
                                                                </div>
                                                            </td>
                                                            <td colspan="2" style="text-align: left">
                                                                <h5 class="black_color">
                                                                    {{ @$item->course->getTranslation('title', $language_code) }}
                                                                </h5>
                                                            </td>

                                                            <td class="black_color">
                                                                {{ $item->is_store ? ($item->course->product->type == 2 ? __('product.Physical') : __('product.Virtual')) : __('product.Virtual') }}
                                                            </td>
                                                            <td class="black_color">
                                                                {{ $item->number_of_product }}
                                                            </td>

                                                            @php
                                                                $price = $item->course->discount_price != 0 ? $item->course->discount_price : $item->course->price;

                                                                if ($item->is_store == 1) {
                                                                    $price1 = $item->course->discount_price != 0 ? $item->course->discount_price : $item->course->price;
                                                                    $price = $price1 * $item->number_of_product;
                                                                } else {
                                                                    $price = $item->course->discount_price != 0 ? $item->course->discount_price : $item->course->price;
                                                                    $price1 = $price;
                                                                }
                                                                $total = $total + $price;
                                                                $shipping_cost = $shipping_cost+$item->shipping_cost;
                                                                $qty = $qty+$item->tax_amount;
                                                            @endphp
                                                            <td style="text-align: left" class="black_color">
                                                                {{ getPriceFormat($price1) }}</td>
                                                            <td style="text-align: left" class="black_color">
                                                                {{ getPriceFormat($price) }}</td>
                                                        </tr>
                                                    @endforeach
                                                    @php
                                                        $p_total = $p_total + $total;
                                                        if (isModuleActive('Tax')) {
                                                            $p_qty = $p_qty + $qty;
                                                        }
                                                    @endphp
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                            <div class="row mt-30">
                                <div class="col-md-12 col-lg-12">
                                    <table class="table-borderless clone_line_table w-100">
                                        <tr>
                                            <td><strong>{{ __('product.Order Info') }}</strong></td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('product.Is Paid') }}</td>
                                            <td class="ps-25 text-nowrap">:
                                                {{ $order->is_paid == 1 ? __('common.Yes') : __('common.No') }}</td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('product.Subtotal') }}</td>
                                            <td class="ps-25 text-nowrap">: {{  getPriceFormat($p_total) }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('common.Discount') }}</td>
                                            <td class="ps-25 text-nowrap">:
                                                @if ($order->discount == 0)
                                                    0
                                                @else
                                                    {{ getPriceFormat($order->discount) }}
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('product.Shipping Charge') }}</td>
                                            <td class="ps-25 text-nowrap">:
                                                {{ getPriceFormat($shipping_cost) }}
                                            </td>
                                        </tr>
                                        @if (isModuleActive('Tax'))
                                            <tr>
                                                <td>{{ __('product.Tax') }}</td>
                                                <td class="ps-25 text-nowrap">:
                                                    {{getPriceFormat($p_qty)}}
                                                </td>
                                            </tr>
                                        @endif

                                        <tr>
                                            <td>{{ __('product.Grand Total') }}</td>
                                            <td class="ps-25 text-nowrap">:
                                                {{ getPriceFormat($p_qty + $p_total + $shipping_cost) }}
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                @if (@$order->order_payment->payment_method == 7)
                                    <div class="col-md-6 col-lg-6">
                                        <table class="table-borderless clone_line_table">
                                            <tr>
                                                <td><strong>{{ __('product.bank_details') }}</strong></td>
                                            </tr>
                                            <tr>
                                                <td>{{ __('common.bank_name') }}</td>
                                                <td>: {{ @$order->order_payment->item_details->bank_name }}</td>
                                            </tr>
                                            <tr>
                                                <td>{{ __('common.branch_name') }}</td>
                                                <td>: {{ @$order->order_payment->item_details->branch_name }}</td>
                                            </tr>
                                            <tr>
                                                <td>{{ __('common.account_number') }}</td>
                                                <td>: {{ @$order->order_payment->item_details->account_number }}</td>
                                            </tr>
                                            <tr>
                                                <td>{{ __('wallet.account_holder') }}</td>
                                                <td>: {{ @$order->order_payment->item_details->account_holder }}</td>
                                            </tr>
                                            <tr>
                                                <td>{{ __('common.attachment') }}</td>
                                                <td>: <a
                                                        href="{{ asset(asset_path(@$order->order_payment->item_details->image_src)) }}"
                                                        target="_blank">{{ __('common.check') }}</a></td>
                                            </tr>
                                        </table>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    @if ($order_packages->course->product_type != 1)
                        <div class="col-lg-4 student-details">
                            @if ($order->is_cancelled != 1 && $order_packages->is_cancelled != 1)
                                <form action="{{ route('order_manage.update_delivery_status', $order_packages->id) }}"
                                      method="post">
                                    @csrf
                                    <div class="row white_box p-25 box_shadow_white me-0 ms-0">
                                        @if($order_packages->order->is_confirmed == 0)
                                            <div class="col-lg-12">
                                                <div class="primary_input">
                                                    <label class="primary_selectlabel alert alert-warning">
                                                        {{__('product.status_is_changable_after_confirmed_the_order')}}
                                                    </label>
                                                </div>
                                            </div>
                                        @endif
                                        <div class="col-lg-12 p-0">
                                            <div class="primary_input mb-25">
                                                <label class="primary_input_label" for="">
                                                    <strong>{{ __('product.delivery_status') }}</strong></label>
                                                <select class="primary_select mb-25" name="delivery_status"
                                                        id="delivery_status" {{$order_packages->order->is_confirmed == 0 || auth()->user()->role->type == 'seller' && $order_packages->delivery_status == 5?'disabled':''}}>
                                                    @foreach ($processes as $key => $process)
                                                        <option value="{{ $process->id }}"
                                                                @if ($order_packages->delivery_status == $process->id) selected @endif>{{ $process->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 p-0">
                                            <div class="primary_input mb-25">
                                                <label class="primary_input_label" for="">
                                                    <strong>{{ __('product.note') }}</strong> </label>
                                                <textarea class="primary_textarea height_112 address"
                                                          placeholder="{{ __('product.note') }}" name="note"
                                                          spellcheck="false"></textarea>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 p-0 text-center">
                                            <div class="d-flex justify-content-center pt_20">
                                                <button type="submit"
                                                        class="primary-btn semi_large csvFormBtn fix-gr-bg"
                                                        id="save_button_parent">
                                                    <i class="ti-check"></i>
                                                    {{ __('common.Update') }}
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            @else
                                <div class="row  white-box box_shadow_white">
                                    <div class="col-lg-12 p-0">
                                        <div class="primary_input mb-25">
                                            <label class="primary_input_label red" for="">
                                                {{ __('product.order_cancelled') }}
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-lg-12 p-0">
                                        <div class="primary_input mb-25">
                                            <label class="primary_input_label sub-title" for="">
                                                <b class="f_w_500 text-uppercase">{{ __('product.reason') }}:</b>
                                                {{ @$order->cancel_reason->name }}
                                            </label>
                                            <label class="primary_input_label sub-details" for="">
                                                <b class="f_w_500 text-uppercase">{{ __('common.Details') }}:</b>
                                                {{ @$order->cancel_reason->description }}
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            @endif
                            @if ($order->note != null)
                                <div class="row white_box p-25 ms-0 me-0 box_shadow_white mt-20">
                                    <div class="description_box">
                                        <h4 class="f_s_14 f_w_500 mb_10">{{ __('common.order') }} {{ __('common.note') }}
                                            :
                                        </h4>
                                        <p class="f_w_400">
                                            {{ $order->note }}
                                        </p>
                                    </div>
                                </div>
                            @endif
                        </div>
                    @endif
                </div>
            </div>
        </section>
    </div>
@endsection
@push('scripts')
    <script type="text/javascript">
        (function ($) {
            "use strict";
            $(document).ready(function () {

                $(document).on('click', '.is_digital_div', function () {
                    var customer_id = $(this).attr("data-customer-id");
                    var seller_id = $(this).attr("data-seller-id");
                    var order_id = $(this).attr("data-order-id");
                    var package_id = $(this).attr("data-package-id");
                    var seller_product_sku_id = $(this).attr("data-seller-sku-id");
                    var product_sku_id = $(this).attr("data-product-sku-id");
                    var mail = $(this).attr("data-customer-mail");
                    var qty = $(this).attr("data-qty");
                    $(this).text('Sending.....');
                    var _this = this;
                    $.post('{{ url('send_digital_file_access_to_customer') }}', {
                        _token: '{{ csrf_token() }}',
                        customer_id: customer_id,
                        seller_id: seller_id,
                        order_id: order_id,
                        package_id: package_id,
                        seller_product_sku_id: seller_product_sku_id,
                        product_sku_id: product_sku_id,
                        mail: mail,
                        qty: qty
                    }, function (data) {
                        if (data == "true" || data == 1) {
                            toastr.success("{{ __('common.mail_has_been_sent_successful') }}",
                                "{{ __('common.success') }}")
                            $(_this).text('Sent')
                        } else {
                            toastr.error("{{ __('common.error_message') }}",
                                "{{ __('common.error') }}");
                            $(_this).text("{{ __('product.send_code_now') }}")
                        }
                    });
                });

                $(document).on('change', '#delivery_status', function (event) {
                    var current_status = $('#current_package_status').val();
                    var change_status = $('#delivery_status').val();
                    if (current_status != change_status) {
                        $('#delivery_note').removeClass('d-none');
                    } else {
                        $('#delivery_note').addClass('d-none');
                    }
                });

                $(document).on('change', '#is_confirmed', function () {
                    let selected_status = $(this).val();
                    if (selected_status == 2) {
                        $('#cancel_reason_selector').removeClass('d-none');
                        $("#is_paid_div").addClass('d-none');
                        $("#is_completed_div").addClass('d-none');
                        $("#delivery_status_div").addClass('d-none');
                    } else {
                        $('#cancel_reason_selector').addClass('d-none');
                        $("#is_paid_div").removeClass('d-none');
                        $("#is_completed_div").removeClass('d-none');
                        $("#delivery_status_div").removeClass('d-none');
                    }
                })

            });
        })(jQuery);
    </script>
@endpush
