@extends('backend.master')
@section('styles')
    <style>
        .anchore_color {
            color: #415094;
        }
    </style>
@endsection
@section('mainContent')
    @if (isModuleActive('FrontendMultiLang'))
        @php
            $LanguageList = getLanguageList();
        @endphp
    @endif
    {{ generateBreadcrumb() }}
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="col-lg-4">
                    @if (isset($edit))
                        <div class="edit_div">
                            @include('store::order.delivery_process.edit')
                        </div>
                    @else
                        <div class="create_div">
                            @include('store::order.delivery_process.create')
                        </div>
                    @endif
                </div>
                <div class="col-lg-8">
                    <div class="white-box">

                        <div class="box_header common_table_header">
                            <div class="main-title d-md-flex">
                                <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px" id="page_title">{{ __('product.delivery_process') }}</h3>
                            </div>
                        </div>
                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table">
                                <div class="">
                                    <div id="refund_process_list">
                                        @include('store::order.delivery_process.process_list')
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <input type="hidden" name="app_base_url" id="app_base_url" value="{{ URL::to('/') }}">

    @include('backend.partials.delete_modal')
@endsection
@include('store::order.delivery_process.scripts')
