<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductBrandsTable extends Migration
{

    public function up()
    {
        Schema::create('product_brands', function (Blueprint $table) {
            $table->id();
            $table->longText("name")->nullable();
            $table->string("logo", 255)->nullable();
            $table->longText("description")->nullable();
            $table->string("link", 255)->nullable();
            $table->boolean("status")->default(1);
            $table->boolean("featured")->default(0);
            $table->longText("meta_title")->nullable();
            $table->longText("meta_description")->nullable();
            $table->unsignedBigInteger("sort_id")->nullable();
            $table->unsignedBigInteger('total_sale')->default(0);
            $table->double('avg_rating', 8, 2)->default(0);
            $table->string("slug", 255)->nullable();
            $table->unsignedBigInteger("created_by")->nullable();
            $table->foreign("created_by")->on("users")->references("id")->onDelete("cascade");
            $table->unsignedBigInteger("updated_by")->nullable();
            $table->foreign("updated_by")->on("users")->references("id")->onDelete("cascade");
            $table->integer('lms_id')->default(1);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('product_brands');
    }
}
