@if (permissionCheck('noticeboard.course.store'))
    <div class="modal fade admin-query" id="add_noticeboard">
        <div class="modal-dialog modal_1000px modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">{{__('common.Add')}} @if($group==2)
                            {{__('courses.Course')}}
                        @else
                            {{__('noticeboard.General')}}
                        @endif {{__('noticeboard.Noticeboard')}}</h4>
                    <button type="button" class="close " data-bs-dismiss="modal">
                        <i class="ti-close "></i>
                    </button>
                </div>

                <div class="modal-body">
                    <form action="{{route($group==2?'noticeboard.course.store':'noticeboard.store')}}" method="POST">
                        @csrf
                        <input type="hidden" name="group" value="{{$group}}">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for="">{{__('common.Title')}}
                                        <strong
                                            class="text-danger">*</strong></label>
                                    <input class="primary_input_field" name="title" placeholder="-"
                                           type="text" id=""
                                           value="{{ old('title') }}" {{$errors->first('title') ? 'autofocus' : ''}}>
                                </div>
                            </div>

                            <div class="col-xl-12">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for="">{{__('common.Type')}}
                                        <strong
                                            class="text-danger">*</strong></label>

                                    <select {{ $errors->has('type') ? ' autofocus' : '' }}
                                            class="primary_select {{ $errors->has('type') ? ' is-invalid' : '' }}"
                                            id="" name="type">
                                        <option data-display="{{__('common.Type')}} *"
                                                value="">  {{__('common.Type')}}
                                        </option>
                                        @foreach($types as $key=>$type)
                                            <option value="{{$key}}">{{$type}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            @if($group==2)
                                <div class="col-xl-12 mb-25 mt-25">
                                    <label class="primary_input_label" for=""> {{__('common.Course')}}
                                        <strong
                                            class="text-danger">*</strong></label>
                                    <select name="course_id[]"
                                            class="multypol_check_select active mb-15 e1" multiple>
                                        @foreach($courses as $key=>$course)
                                            <option value="{{$key}}">{{$course}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            @elseif($group==1)
                                <div class="col-xl-12 mb-25 mt-25">
                                    <label class="primary_input_label" for=""> {{__('common.Role')}}
                                        <strong
                                            class="text-danger">*</strong></label>
                                    <select name="role_id[]"
                                            class="multypol_check_select active mb-15 e1" multiple>
                                        @foreach($roles as $key=>$role)
                                            <option value="{{$key}}">{{$role}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            @endif
                            <div class="col-xl-12">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for="">{{__('noticeboard.Message')}}
                                        <strong
                                            class="text-danger">*</strong></label>
                                    <textarea name="message" class="lms_summernote"></textarea>
                                </div>
                            </div>


                        </div>

                        <div class="col-lg-12 text-center pt_15">
                            <div class="d-flex justify-content-center">
                                <button class="primary-btn semi_large2  fix-gr-bg"
                                        id="save_button_parent"
                                        type="submit"><i
                                        class="ti-check"></i> {{__('common.Save')}} @if($group==2)
                                        {{__('courses.Course')}}
                                    @else
                                        {{__('noticeboard.General')}}
                                    @endif {{__('noticeboard.Noticeboard')}}
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endif
