@extends('backend.master')
@section('mainContent')
    {!! generateBreadcrumb() !!}
    <style>
        .target_list {
            list-style: none;
            padding: 0;
            max-height: 200px;
            overflow-y: auto;

        }
    </style>
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-lg-12">
                    <div class="white_box mb_20">
                        <div class="white_box_tittle list_header main-title mb-0">
                            <h3 class="mb-0">{{__('courses.Advanced Filter')}} </h3>
                        </div>
                        <div class="row">

                            <div class="col-lg-4 mt-20">
                                <label class="primary_input_label"
                                       for="category">{{ _trans('cashback.User Name') }}</label>
                                <input class="primary_input_field" name="name" placeholder="-" id="name" type="text"
                                       value="">
                            </div>
                            <div class="col-lg-4 mt-20">
                                <div class="primary_input mb-15">
                                    <label class="primary_input_label"
                                           for="">{{_trans('cashback.Start Date')}}
                                    </label>
                                    <div class="primary_datepicker_input">
                                        <div class="g-0 input-right-icon">
                                            <div class="col">
                                                <div class="">
                                                    <input placeholder="{{_trans('cashback.Start Date')}}"
                                                           class="primary_input_field primary-input date form-control"
                                                           id="startDate" type="text" name="start_date"
                                                           value=""
                                                           autocomplete="off">
                                                </div>
                                            </div>
                                            <button class="" type="button">
                                                <i class="ti-calendar" id="start-date-icon"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4 mt-20">
                                <div class="primary_input mb-15">
                                    <label class="primary_input_label"
                                           for="">{{_trans('cashback.End Date')}}
                                    </label>
                                    <div class="primary_datepicker_input">
                                        <div class="g-0 input-right-icon">
                                            <div class="col">
                                                <div class="">
                                                    <input placeholder="{{_trans('cashback.End Date')}}"
                                                           class="primary_input_field primary-input date form-control"
                                                           id="endDate" type="text" name="end_date"
                                                           value=""
                                                           autocomplete="off">
                                                </div>
                                            </div>
                                            <button class="" type="button">
                                                <i class="ti-calendar" id="end-date-icon"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="col-12  ">
                                <div class="search_course_btn text-end">
                                    <button type="submit" id="filter_result"
                                            class="primary-btn radius_30px fix-gr-bg">
                                        <i class="ti-search"></i>
                                        {{__('courses.Filter')}} </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div class="white-box">
                        <div class="row">
                            <div class="col-lg-12">

                                <div class="main-title d-md-flex mb-20">
                                    <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px"
                                        id="page_title">{{ $data['title'] }}</h3>

                                </div>

                                <div class="QA_section QA_section_heading_custom check_box_table">
                                    <div class="QA_table ">
                                        <!-- table-responsive -->
                                        <div class="">
                                            <table id="lms_table" class="table Crm_table_active3">
                                                <thead>
                                                <tr>
                                                    <th scope="col">{{_trans('cashback.SL')}}</th>
                                                    <th scope="col">{{_trans('cashback.Image')}}</th>
                                                    <th scope="col">{{_trans('cashback.Name')}}</th>
                                                    <th scope="col">{{_trans('cashback.Total Purchase')}}</th>
                                                    <th scope="col">{{_trans('cashback.Cashback Amount')}}</th>
                                                    <th scope="col">{{_trans('cashback.Last cashback')}}</th>
                                                    <th scope="col">{{_trans('cashback.Action')}}</th>
                                                </tr>
                                                </thead>
                                                <tbody>

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <input type="hidden" name="status_route" class="status_route" value="{{ route('coupons.status_update') }}">


    @include('backend.partials.delete_modal')
@endsection
@push('scripts')
    @php
        $url = route('cashback.history_ajax');
    @endphp

    <script>
        (function ($) {
            "use strict";
            dataTableOptions.processing = true
            dataTableOptions.serverSide = true
            dataTableOptions.ajax = {
                url: "{{$url}}", // URL for fetching data
                data: function (d) {
                    d.name = $('#name').val(); // Additional parameters
                    d.startDate = $('#startDate').val();
                    d.endDate = $('#endDate').val();
                }
            };
            dataTableOptions.columns = [
                {data: 'DT_RowIndex', name: 'id', orderable: true},
                {data: 'image', name: 'image', orderable: false, searchable: false},
                {data: 'name', name: 'user.name'},
                {data: 'total_purchase', name: 'total_purchase', searchable: false},
                {data: 'total_cashback', name: 'total_cashback', searchable: false},
                {data: 'last_cashback', name: 'last_cashback', searchable: false},
                {data: 'action', name: 'action', orderable: false, searchable: false},
            ];
            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 2, 3, 4, 5]);

            let table = $('#lms_table').DataTable(dataTableOptions);
            $('#filter_result').on('click', function (e) {
                e.preventDefault();
                table.ajax.reload(null, false);
            });
        })(jQuery);


    </script>
@endpush
