@extends('backend.master')
@section('mainContent')
    {!! generateBreadcrumb() !!}
    <style>
        .target_list {
            list-style: none;
            padding: 0;
            max-height: 200px;
            overflow-y: auto;

        }
    </style>
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="white-box">
                <div class="row">
                    <div class="col-lg-12">

                        <div class="main-title d-md-flex justify-content-md-between mb-20">
                            <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px" id="page_title">{{ $data['title'] }}</h3>
                            <ul class="d-flex">
                                <li>
                                    <a class="primary-btn radius_30px fix-gr-bg"
                                       href="{{ route('cashback.rules.create') }}"><i
                                            class="ti-plus"></i>{{ _trans('cashback.Add Rule') }} </a>
                                </li>
                            </ul>

                        </div>

                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <!-- table-responsive -->
                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            @foreach ($data['table_columns'] as $th)
                                                <th scope="col">{{ $th }}</th>
                                            @endforeach
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($data['rules'] as $key => $rule)
                                            <tr>
                                                <th>{{ $key + 1 }}</th>

                                                <td>{{ @$rule->getTranslation('title', auth()->user()->language_code ?? 'en') }}</td>
                                                <td>{{ _trans('cashback.'.@$rule->rule_specific_item->target_type) }}</td>
                                                <td>
                                                    {{ $rule->amount_type == 'percent' ? $rule->amount . '%' : getPriceFormat($rule->amount) }}
                                                </td>
                                                <td>
                                                    {{showPrice($rule->userCashbackDetails->sum('cashback_amount'))}}
                                                </td>
                                                <td>
                                                    {{$rule->totalUser()}}
                                                </td>
                                                <td>{{ showDate($rule->start_datetime) . ' | ' . showTime($rule->start_datetime) }}
                                                </td>
                                                <td>{{ $rule->end_datetime != null ? showDate($rule->end_datetime) . ' | ' . showTime($rule->end_datetime) : _trans('cashback.Unlimited') }}
                                                </td>
                                                <td>
                                                    {{ $rule->statusText }}
                                                </td>
                                                <td>
                                                    <!-- shortby  -->
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu2" data-bs-toggle="dropdown"
                                                                aria-haspopup="true"
                                                                aria-expanded="false">
                                                            {{ __('common.Select') }}
                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu2">
                                                            @if (permissionCheck('cashback.rules.edit'))
                                                                <a class="dropdown-item edit_brand"
                                                                   href="{{ route('cashback.rules.edit', @$rule->id) }}">{{ _trans('common.Edit') }}</a>
                                                            @endif

                                                            <a class="dropdown-item" data-bs-toggle="modal"
                                                               data-bs-target="#viewCashbackRuleModal{{ @$rule->id }}"
                                                               href="#">{{ __('common.View') }}</a>


                                                            @if (permissionCheck('cashback.rules.delete'))
                                                                <a class="dropdown-item" data-bs-toggle="modal"
                                                                   data-bs-target="#deleteQuestionGroupModal{{ @$rule->id }}"
                                                                   href="#">{{ __('common.Delete') }}</a>
                                                            @endif

                                                        </div>
                                                    </div>
                                                    <!-- shortby  -->
                                                </td>
                                            </tr>

                                            <div class="modal fade admin-query"
                                                 id="viewCashbackRuleModal{{ $rule->id }}">
                                                <div class="modal-dialog modal-dialog-centered modal_1000px">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title">{{ _trans('cashback.Cashback') }} {{ _trans('cashback.Rule') }} {{ __('common.View') }}</h4>
                                                            <button type="button" class="btn-close"
                                                                    data-bs-dismiss="modal"><i
                                                                    class="ti-close "></i></button>
                                                        </div>

                                                        <div class="modal-body">
                                                            <div class="text-center">
                                                                <h4> {{ @$rule->getTranslation('title', auth()->user()->language_code ?? 'en') }}</h4>
                                                            </div>
                                                            <hr>
                                                            <div class="row">
                                                                <div class="col-lg-6"
                                                                     style="border-right: 1px solid gray">
                                                                    <div class="row">
                                                                        <div class="col-lg-4 fw-bold">
                                                                            {{_trans('cashback.Target Type')}}
                                                                        </div>
                                                                        <div class="col-lg-1">
                                                                            :
                                                                        </div>
                                                                        <div class="col-lg-7">
                                                                            {{ _trans('cashback.'.@$rule->rule_specific_item->target_type) }}
                                                                        </div>
                                                                    </div>
                                                                    <div class="row">
                                                                        <div class="col-lg-4 fw-bold">
                                                                            {{_trans('cashback.Amount')}}
                                                                        </div>
                                                                        <div class="col-lg-1">
                                                                            :
                                                                        </div>
                                                                        <div class="col-lg-7">
                                                                            {{ $rule->amount_type == 'percent' ? $rule->amount . '%' : getPriceFormat($rule->amount) }}
                                                                        </div>
                                                                    </div>
                                                                    <div class="row">
                                                                        <div class="col-lg-4 fw-bold">
                                                                            {{_trans('cashback.Paid Amount')}}
                                                                        </div>
                                                                        <div class="col-lg-1">
                                                                            :
                                                                        </div>
                                                                        <div class="col-lg-7">
                                                                            {{showPrice($rule->userCashbackDetails->sum('cashback_amount'))}}
                                                                        </div>
                                                                    </div>
                                                                    <div class="row">
                                                                        <div class="col-lg-4 fw-bold">
                                                                            {{_trans('cashback.Users')}}
                                                                        </div>
                                                                        <div class="col-lg-1">
                                                                            :
                                                                        </div>
                                                                        <div class="col-lg-7">
                                                                            {{$rule->totalUser()}}
                                                                        </div>
                                                                    </div>
                                                                    <div class="row">
                                                                        <div class="col-lg-4 fw-bold">
                                                                            {{_trans('cashback.Start Date')}}
                                                                        </div>
                                                                        <div class="col-lg-1">
                                                                            :
                                                                        </div>
                                                                        <div class="col-lg-7">
                                                                            {{ showDate($rule->start_datetime) . ' | ' . showTime($rule->start_datetime) }}
                                                                        </div>
                                                                    </div>
                                                                    <div class="row">
                                                                        <div class="col-lg-4 fw-bold">
                                                                            {{_trans('cashback.End Date')}}
                                                                        </div>
                                                                        <div class="col-lg-1">
                                                                            :
                                                                        </div>
                                                                        <div class="col-lg-7">
                                                                            {{ $rule->end_datetime != null ? showDate($rule->end_datetime) . ' | ' . showTime($rule->end_datetime) : _trans('cashback.Unlimited') }}
                                                                        </div>
                                                                    </div>
                                                                    <div class="row">
                                                                        <div class="col-lg-4 fw-bold">
                                                                            {{_trans('cashback.Status')}}
                                                                        </div>
                                                                        <div class="col-lg-1">
                                                                            :
                                                                        </div>
                                                                        <div class="col-lg-7">
                                                                            {{ $rule->statusText }}
                                                                        </div>
                                                                    </div>
                                                                    <div class="row">
                                                                        <div class="col-lg-4 fw-bold">
                                                                            {{_trans('cashback.Apply Cashback Per Item')}}
                                                                        </div>
                                                                        <div class="col-lg-1">
                                                                            :
                                                                        </div>
                                                                        <div class="col-lg-7">
                                                                            {{ $rule->apply_cashback_per_item == 1? _trans('cashback.Yes') : _trans('cashback.No') }}
                                                                        </div>
                                                                    </div>
                                                                </div>

                                                                <div class="col-lg-6"
                                                                     style="border-left: 1px solid gray">
                                                                    <h3 class="text-center">
                                                                        {{_trans('cashback.Target')}}
                                                                        ({{ _trans('cashback.'.@$rule->rule_specific_item->target_type)}} {{ $rule->rule_specific_item->target != null ? '->'._trans('cashback.'.Str::ucfirst(Str::replace('_',' ',@$rule->rule_specific_item->target))) :'' }}
                                                                        )
                                                                    </h3>
                                                                    <div class="">
                                                                        @php
                                                                            $rule_items= $rule->rule_specific_item ? $rule->rule_specific_item->rule_specific_item_details_relation : [];
                                                                        @endphp
                                                                        <ul class="target_list">
                                                                            @foreach ($rule_items as $key => $item)
                                                                                <li>
                                                                                    @php
                                                                                        $json_check = json_decode($item->itemInfo->name, true);
                                                                                    @endphp

                                                                                    @if($json_check)
                                                                                        {{++$key}}
                                                                                        . {{json_trans(@$item->itemInfo->name, auth()->user()->language_code ?? 'en')}}
                                                                                    @else
                                                                                        {{++$key}}
                                                                                        . {{ @$item->itemInfo->name }}
                                                                                    @endif
                                                                                </li>
                                                                            @endforeach

                                                                        </ul>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="mt-40 d-flex justify-content-end">
                                                                <button type="button" class="primary-btn tr-bg"
                                                                        data-bs-dismiss="modal">{{ __('common.Cancel') }}</button>

                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="modal fade admin-query"
                                                 id="deleteQuestionGroupModal{{ $rule->id }}">
                                                <div class="modal-dialog modal-dialog-centered">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title">{{ __('common.Delete') }}
                                                                {{ _trans('cashback.Cashback') }}
                                                                {{ _trans('cashback.Rule') }}</h4>
                                                            <button type="button" class="btn-close"
                                                                    data-bs-dismiss="modal"><i
                                                                    class="ti-close "></i></button>
                                                        </div>

                                                        <div class="modal-body">
                                                            <div class="text-center">
                                                                <h4> {{ __('common.Are you sure to delete ?') }}</h4>
                                                            </div>

                                                            <div class="mt-40 d-flex justify-content-between">
                                                                <button type="button" class="primary-btn tr-bg"
                                                                        data-bs-dismiss="modal">{{ __('common.Cancel') }}</button>
                                                                <form action="{{ route('cashback.rules.delete') }}" method="POST" enctype="multipart/form-data">
                                                                <input type="hidden" name="id"
                                                                       value="{{ $rule->id }}">
                                                                <button class="primary-btn fix-gr-bg"
                                                                        type="submit">{{ __('common.Delete') }}</button>
                                                                </form>
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <input type="hidden" name="status_route" class="status_route" value="{{ route('coupons.status_update') }}">

@endsection
@push('scripts')
    <script src="{{ asset('public/backend/js/category.js') }}"></script>
@endpush
