@extends('appointment::layouts.master')

@section('mainContent')
    <input type="hidden" id="row_count" value="1">
    {{generateBreadcrumb()}}
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="col-lg-12">
                    <div class="white_box mb_30">
                        <div class="white_box_tittle list_header">
                            <h2> {{ $post->userInfo->name }} {{ __('appointment.Searching Instructor') }} </h2>
                            <h2> {{ __('courses.Category') }} : <strong>{{ $post->category->name }} </strong></h2>
                            <h2> {{ __('common.Price') }} : [ {{ $post->min_price ? $post->min_price : ' ' }}
                                {{ $post->max_price ? ' - ' . $post->max_price : '' }}]
                            </h2>

                        </div>
                        @php
                            $div = 'col-xl-6 col-md-6 col-lg-6';
                            $divBtn = 'col-md-12 col-xl-12 mt-30';
                        @endphp


                        <form action="{{ route('appointment.post.share-instructor.store') }}" method="POST">
                            @csrf
                            <div class="row">
                                <input type="hidden" name="student_id" value="{{ $post->user_id }}">
                                <input type="hidden" name="post_id" value="{{ $post->id }}">
                                <div class="{{ $div }}">

                                    <label class="primary_input_label"
                                           for="category">{{ __('courses.Category') }}</label>
                                    <select class="primary_select categoryInstructor" name="category" id="category">
                                        <option data-display="{{ __('common.Select') }} {{ __('courses.Category') }}"
                                                value="">{{ __('common.Select') }} {{ __('courses.Category') }}</option>
                                        @foreach ($categories as $category)
                                            <option value="{{ $category->id }}"
                                                {{ $category->id == $post->teaching_category ? 'selected' : '' }}> {{ $category->name }} </option>
                                        @endforeach
                                    </select>

                                </div>
                                <div class="{{ $div }}" id="instructorDiv">
                                    <div class="primary_input mb-15">
                                        <label class="primary_input_label"
                                               for="instructor">{{ __('appointment.Instructor') }}</label>
                                        <select class="primary_select instructor" name="instructor_id" id="instructor">
                                            <option
                                                data-display="{{ __('common.Select') }} {{ __('appointment.Instructor') }}"
                                                value="">{{ __('common.Select') }} {{ __('appointment.Instructor') }}</option>
                                            @foreach ($instructors as $instructor)
                                                <option value="{{ $instructor->id }}"> {{ $instructor->name }} </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="{{ $divBtn }}">
                                    <div class="search_course_btn text-center">
                                        <button type="submit"
                                                class="primary-btn radius_30px   fix-gr-bg">{{ __('common.Submit') }}</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@push('scripts')
    <script>
        (function ($) {
            "use strict";
            $(document).ready(function () {
                let category_id = "{{ $post->teaching_category }}";
                categoryInstructor(category_id);
            })
            $(document).on('change', '.categoryInstructor', function () {

                let category_id = $(this).val();
                categoryInstructor(category_id);
            })

            function categoryInstructor(category_id) {
                var url = $("#url").val();
                var formData = {
                    category_id: category_id,
                };
                $.ajax({
                    type: "GET",
                    data: formData,
                    dataType: "json",
                    url: "{{ route('appointment.post.category-instructor') }}",
                    success: function (data) {
                        var a = "";
                        $.each(data, function (i, instructors) {
                            console.log(instructors.length);
                            if (instructors.length) {
                                $("#instructor").find("option").not(":first").remove();
                                $("#instructorDiv ul").find("li").not(":first").remove();

                                $.each(instructors, function (i, instructor) {
                                    $("#instructor").append(
                                        $("<option>", {
                                            value: instructor.id,
                                            text: instructor.name,
                                        })
                                    );

                                    $("#instructorDiv ul").append(
                                        "<li data-value='" +
                                        instructor.id +
                                        "' class='option'>" +
                                        instructor.name +
                                        "</li>"
                                    );
                                });
                            } else {
                                $("#instructorDiv .current").html("Select Instructor");
                                $("#instructor").find("option").not(":first").remove();
                                $("#instructorDiv ul").find("li").not(":first").remove();
                            }
                        });
                        // console.log(a);
                    },
                    error: function (data) {
                        console.log("Error:", data);
                    },
                });
            }

        })(jQuery);
    </script>
@endpush
