@extends('appointment::layouts.master')
@push('styles')
    <link rel="stylesheet" href="{{ asset('public/backend/css/student_list.css') }}"/>
@endpush


@section('mainContent')
    <input type="hidden" id="educationDiv" value="0">
    <input type="hidden" id="certificateDiv" value="0">
    <input type="hidden" id="experienceDiv" value="0">
    <input type="hidden" id="teachingCategoryDiv" value="0">
    <input type="hidden" id="teachingLanguageDiv" value="0">
    <input type="hidden" id="socialMediaDiv" value="0">
    {{generateBreadcrumb()}}
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="box_header common_table_header">
                        <div class="main-title d-md-flex">
                            <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px">
                                @if (!isset($edit))
                                    {{ __('appointment.Add New Instructor') }}
                                @else
                                    {{ __('appointment.Update Instructor') }}
                                @endif
                            </h3>
                        </div>
                    </div>

                    <div class="white-box mb_30">
                        <form
                            @if (isset($edit))
                                @if (permissionCheck('instructor.update'))
                                    method="POST" action="{{ route('instructor.update') }}" class="form-horizontal"
                            id="expertise-form" name="expertise-form">
                            @method('PUT')
                            @csrf
                            <input type="hidden" name="id" value="{{ $edit->id }}" id="instructorId">

                            @endif
                            @else
                                @if (permissionCheck('instructor.store'))
                                    method="POST" action="{{ route('instructor.store') }}" class="form-horizontal"
                                    enctype="multipart/form-data" name="expertise-form">
                                    @csrf
                                @endif
                            @endif

                            <div class="row">
                                <div class="col-xl-4">
                                    <div class="primary_input mb-25">
                                        <label class="primary_input_label" for="">{{ __('common.Name') }} <strong
                                                class="text-danger">*</strong></label>
                                        <input class="primary_input_field" name="name" placeholder="-" id="addName"
                                               type="text"
                                               value="{{ old('name') }}" {{ $errors->first('name') ? 'autofocus' : '' }}>
                                    </div>
                                </div>
                                <div class="col-xl-4">
                                    <div class="primary_input mb-25">
                                        <label class="primary_input_label" for="">{{ __('appointment.Specialist') }}
                                            <strong
                                                class="text-danger">*</strong></label>
                                        <input class="primary_input_field" name="headline" placeholder=""
                                               id="headline" type="text"
                                               value="{{ old('headline') }}" {{ $errors->first('headline') ? 'autofocus' : '' }}>
                                    </div>
                                </div>
                                <div class="col-xl-4">
                                    <div class="primary_input mb-15">
                                        <label class="primary_input_label" for="">{{ __('common.Date of Birth') }}
                                        </label>
                                        <div class="primary_datepicker_input">
                                            <div class="g-0  input-right-icon">
                                                <div class="col">
                                                    <div class="">
                                                        <input placeholder="{{ __('common.Date') }}"
                                                               class="primary_input_field primary-input date form-control"
                                                               id="startDate" type="text" name="dob"
                                                               value="{{ old('dob') }}"
                                                               {{ $errors->first('dob') ? 'autofocus' : '' }}
                                                               autocomplete="off">
                                                    </div>
                                                </div>
                                                <button class="" type="button">
                                                    <i class="ti-calendar" id="start-date-icon"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-4">
                                    <div class="primary_input mb-25">
                                        <label class="primary_input_label" for="">{{ __('common.Phone') }} </label>
                                        <input class="primary_input_field phoneNumberInput" value="{{ old('phone') }}"
                                               name="phone"
                                               id="addPhone" placeholder="-"
                                               {{ $errors->first('phone') ? 'autofocus' : '' }}
                                               type="text">
                                    </div>
                                </div>
                                <div class="col-xl-4">
                                    <div class="primary_input mb-25">
                                        <label class="primary_input_label" for="">{{ __('common.Email') }} <strong
                                                class="text-danger">*</strong></label>
                                        <input class="primary_input_field" name="email" placeholder="-" id="addEmail"
                                               value="{{ old('email') }}"
                                               {{ $errors->first('email') ? 'autofocus' : '' }}
                                               type="email">
                                    </div>
                                </div>


                                <div class="col-xl-4">
                                    <div class="primary_input mb-25">
                                        <label class="primary_input_label"
                                               for="gender">{{ __('common.Gender') }}</label>
                                        <select class="primary_select " name="gender" id="gender_id"
                                            {{ $errors->has('gender') ? 'autofocus' : '' }}>
                                            <option data-display="{{ __('appointment.Select Gender') }} "
                                                    value="">{{ __('appointment.Select Gender') }}  </option>

                                            <option value="male">{{ __('common.Male') }}</option>
                                            <option value="female">{{ __('common.Female') }}</option>
                                            <option value="others">{{ __('common.Others') }}</option>

                                        </select>
                                    </div>
                                </div>
                                <div class="col-xl-4">
                                    <div class="  mb-35">
                                        <x-upload-file
                                            name="image"
                                            type="image"
                                             label="{{ __('common.Image') }}"
                                            note="{{__('student.Recommended size')}} (330x400)"/>

                                    </div>
                                </div>


                                <div class="col-xl-4">
                                    <div class="primary_input mb-25">
                                        <label class="primary_input_label" for="">{{__('common.Password')}}
                                            <strong
                                                class="text-danger">*</strong></label>
                                        <div class="input-group mb-2 mr-sm-2">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i style="cursor:pointer;"
                                                                                 class="fas fa-eye-slash eye toggle-password"></i>
                                                </div>
                                            </div>
                                            <input type="password" class="form-control primary_input_field"
                                                   id="addPassword" name="password"
                                                   autocomplete="new-password"
                                                   placeholder="{{__('common.Minimum 8 characters')}}" {{$errors->first('password') ? 'autofocus' : ''}}>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-4">
                                    <div class="primary_input mb-25">
                                        <label class="primary_input_label"
                                               for="">{{__('common.Confirm Password')}} <strong
                                                class="text-danger">*</strong></label>
                                        <div class="input-group mb-2 mr-sm-2">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i style="cursor:pointer;"
                                                                                 class="fas fa-eye-slash eye toggle-password"></i>
                                                </div>
                                            </div>
                                            <input type="password" class="form-control primary_input_field"
                                                   {{$errors->first('password_confirmation') ? 'autofocus' : ''}}
                                                   id="addCpassword" name="password_confirmation"
                                                   placeholder="{{__('common.Minimum 8 characters')}}">
                                        </div>
                                        {{--                                                    <input class="primary_input_field"  name="password_confirmation" placeholder="-" type="text">--}}
                                    </div>
                                </div>


                                <div class="col-xl-12">
                                    @includeIf('appointment::instructor.inc.social')
                                </div>

                                <div class="col-xl-12">
                                    @includeIf('appointment::instructor.inc.education')
                                </div>

                                <div class="col-xl-12">
                                    @includeIf('appointment::instructor.inc.certificate')
                                </div>

                                <div class="col-xl-12">
                                    @includeIf('appointment::instructor.inc.work_experience')
                                </div>

                                <div class="col-xl-7">
                                    @includeIf('appointment::instructor.inc.teachingCategory')
                                </div>
                                <div class="col-xl-5">
                                    @includeIf('appointment::instructor.inc.teachingLanguage')
                                </div>

                                <div class="col-xl-12 mt-25">
                                    <div class="row mt-25">
                                        <div class="col-xl-2">
                                            <div class="primary_input mb-25">
                                                <label class="primary_input_label" for="">
                                                    @php
                                                        $type = Settings('currency_show');
                                                    @endphp
                                                    {{ $type==1 || $type==2 ? '('.Settings('currency_symbol').')':'' }}
                                                    {{ __('appointment.Hour Rate') }}  {{ $type==3 || $type==4 ? '('. Settings('currency_symbol'). ')':'' }}
                                                </label>
                                                <input class="primary_input_field" value="{{ old('hour_rate') }}"
                                                       name="hour_rate"
                                                       id="addPhone" placeholder="{{Settings('currency_symbol')}}"
                                                       {{ $errors->first('hour_rate') ? 'autofocus' : '' }}
                                                       type="text">
                                            </div>
                                        </div>
                                        <div class="col-xl-3 mb_30">
                                            <label class="primary_input_label"
                                                   for="type">{{ __('appointment.Teaching Type') }} <strong
                                                    class="text-danger">*</strong></label>

                                            <select name="type[]" id="type"
                                                    class="multypol_check_select active mb-15 e1"
                                                    multiple>

                                                <option value="2">{{ __('appointment.In-Person') }}</option>
                                                <option value="3">{{ __('appointment.Online') }}</option>
                                                <option value="4">{{ __('appointment.Individual') }}</option>
                                                <option value="5">{{ __('appointment.Group') }}</option>
                                                <option value="6">{{ __('appointment.Individual(Online)') }}</option>
                                                <option value="7">{{ __('appointment.Group(Online)') }}</option>
                                            </select>
                                        </div>
                                        <div class="col-xl-2">
                                            <label for="">{{ __('appointment.Available') }}</label> <br>
                                            <p>{{ __('common.No') }} / {{ __('common.Yes') }}</p>
                                            <label class="switch_toggle"
                                                   for="availableMessage">
                                                <input type="checkbox" name="available" class="status_enable_disable"
                                                       id="availableMessage" checked>
                                                <i class="slider round"></i>

                                            </label>
                                        </div>
                                        <div class="col-xl-5 " id="availableMessageDiv">
                                            <div class="primary_input mb-25">
                                                <label class="primary_input_label" id="availableMessageYes"
                                                       for="">{{ __('appointment.Available Message') }} <strong
                                                        class="text-danger">*</strong></label>
                                                <label class="primary_input_label d-none" id="availableMessageNo"
                                                       for="">{{ __('appointment.Not Available Message') }} <strong
                                                        class="text-danger">*</strong></label>
                                                <input class="primary_input_field" name="available_message"
                                                       placeholder="-"
                                                       type="text" value="{{ old('available_message') }}"
                                                    {{ $errors->first('available_message') ? 'autofocus' : '' }}>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-6">
                                    <div class="primary_input mb-25">
                                        <label class="primary_input_label"
                                               for="">{{ __('appointment.Short video Link') }}
                                            <strong class="text-danger"></strong></label>
                                        <input class="primary_input_field" name="video_link" placeholder="www."
                                               id="video_link" type="text"
                                               value="{{ old('video_link') }}" {{ $errors->first('video_link') ? 'autofocus' : '' }}>
                                    </div>
                                </div>
                                {{-- end teaching area --}}
                                <div class="col-xl-12">
                                    <div class="primary_input mb-35">
                                        <label class="primary_input_label" for="">{{ __('instructor.About') }}</label>
                                        <textarea class="lms_summernote" name="about" id="addAbout" cols="30"
                                                  rows="10">{{ old('about') }}</textarea>
                                    </div>
                                </div>


                                <div class="col-lg-12 text-center">
                                    <div class="d-flex justify-content-center pt_20">
                                        <button type="submit" class="primary-btn semi_large fix-gr-bg"
                                                data-bs-toggle="tooltip"
                                                title="" id="save_button_parent">
                                            <i class="ti-check"></i>
                                            @if (!isset($edit))
                                                {{ __('common.Save') }}
                                            @else
                                                {{ __('common.Update') }}
                                            @endif
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </div>
    </section>
@endsection
@push('scripts')
    <script src="{{asset('public/backend/js/instructor_list.js')}}"></script>
@endpush
