<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBookingsTable extends Migration
{
    public function up()
    {
        Schema::create('bookings', function (Blueprint $table) {
            $table->id();
            $table->string('tracking')->default(1)->nullable();
            $table->integer('user_id')->nullable();
            $table->integer('instructor_id')->nullable();
            $table->integer('slot_id')->nullable();
            $table->integer('schedule_id')->nullable();
            $table->float('purchase_price')->comment('hour_rate');
            $table->string('coupon')->nullable();
            $table->float('discount_amount')->default(0);
            $table->boolean('status')->default(1);
            $table->float('revenue')->default(0.00);
            $table->text('reason')->nullable();
            $table->string('type')->nullable();
            $table->string('timezone')->nullable();
            $table->text('share_link')->nullable();
            $table->text('note')->nullable();
            $table->tinyInteger('payment_status')->nullable()->default(0);
            $table->string('payment_type')->nullable()->default(0);
            $table->integer('lms_id')->default(1);

            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('bookings');
    }
}
