<?php

namespace Modules\Affiliate\Entities;

use App\Traits\Tenantable;
use App\User;
use Illuminate\Database\Eloquent\Model;
use Modules\BundleSubscription\Entities\BundleCoursePlan;
use Modules\CourseSetting\Entities\Course;
use Modules\Subscription\Entities\CourseSubscription;

class AffiliateReferralPayment extends Model
{
    use Tenantable;

    protected $guarded = ['id'];

    public function course()
    {
        return $this->belongsTo(Course::class, 'course_id');
    }

    public function bundle()
    {
        return $this->belongsTo(BundleCoursePlan::class, 'bundle_id');
    }

    public function plan()
    {
        return $this->belongsTo(CourseSubscription::class, 'plan_id');
    }

    public function incomeFrom()
    {
        return $this->belongsTo(User::class, 'payment_from');
    }
}
